/*
 * Decompiled with CFR 0.152.
 */
package io.ryos.rhino.sdk;

import io.ryos.rhino.sdk.exceptions.ExceptionUtils;
import io.ryos.rhino.sdk.exceptions.RhinoIOException;
import io.ryos.rhino.sdk.io.ConfigResource;
import io.ryos.rhino.sdk.users.source.UserSource;
import io.ryos.rhino.sdk.utils.Environment;
import io.ryos.rhino.sdk.validators.PropsValidatorImpl;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import java.util.Properties;
import java.util.UUID;

public class SimulationConfig {
    private static final String PACKAGE_TO_SCAN = "packageToScan";
    private static final int PAR_RATIO = 5;
    private static final int MAX_PAR = 1000;
    private static final int MAX_CONN = 1000;
    private static final String SIM_ID = "SIM_ID";
    private static SimulationConfig instance;
    private final Properties properties = new Properties();
    private final String environment;
    private final String simulationId;

    private SimulationConfig(String path, Environment environment) {
        this.environment = environment.toString();
        this.simulationId = Optional.ofNullable(System.getenv().get(SIM_ID)).orElse(UUID.randomUUID().toString());
        this.loadConfig(path);
    }

    static SimulationConfig newInstance(String path, Environment environment) {
        if (instance != null) {
            return instance;
        }
        instance = new SimulationConfig(path, environment);
        return instance;
    }

    private void loadConfig(String path) {
        try (InputStream is = new ConfigResource(path).getInputStream();){
            this.properties.load(is);
            PropsValidatorImpl propsValidator = new PropsValidatorImpl();
            propsValidator.validate(this.properties);
        }
        catch (IOException e) {
            ExceptionUtils.rethrow(e, RhinoIOException.class, "Cannot read rhino.properties file.");
        }
    }

    private String getProperty(String prop) {
        return this.properties.getProperty(prop);
    }

    private String getGrafanaURL() {
        return this.properties.getProperty("grafana.endpoint");
    }

    private String grafanaToken() {
        return this.properties.getProperty("grafana.token");
    }

    private String grafanaUsername() {
        return this.properties.getProperty("grafana.username");
    }

    private String grafanaPassword() {
        return this.properties.getProperty("grafana.password");
    }

    private String getDBSupportInfluxURL() {
        return this.properties.getProperty("db.influx.url");
    }

    private String getDBSupportInfluxDBName() {
        return this.properties.getProperty("db.influx.dbName");
    }

    private String getDBSupportInfluxUsername() {
        return this.properties.getProperty("db.influx.username");
    }

    private String getDBSupportInfluxPassword() {
        return this.properties.getProperty("db.influx.password");
    }

    private String getNodeName() {
        return this.properties.getProperty("node");
    }

    private UserSource.SourceType getUsersSource() {
        String source = this.properties.getProperty(this.environment + ".users.source", "file");
        return UserSource.SourceType.valueOf(source.toUpperCase());
    }

    private String getConfigHttpMaxConnections() {
        return this.properties.getProperty("http.maxConnections", "1000");
    }

    private String getConfigHttpConnectTimeout() {
        return this.properties.getProperty("http.connectTimeout", "60000");
    }

    private String getConfigHttpReadTimeout() {
        return this.properties.getProperty("http.readTimeout", "15000");
    }

    private String getConfigHttpHandshakeTimeout() {
        return this.properties.getProperty("http.handshakeTimeout", "60000");
    }

    private String getConfigHttpRequestTimeout() {
        return this.properties.getProperty("http.requestTimeout", "60000");
    }

    private String getRunnerParallelisation() {
        return this.properties.getProperty("runner.parallelisim", Integer.toString(Runtime.getRuntime().availableProcessors() * 5));
    }

    private String getAuthUserFileSource() {
        return this.properties.getProperty(this.environment + ".users.file");
    }

    private String getAuthClientId() {
        return this.properties.getProperty(this.environment + ".oauth.clientId");
    }

    private String getAuthApiKey() {
        return this.properties.getProperty(this.environment + ".oauth.apiKey");
    }

    private String getAuthEndpoint() {
        return this.properties.getProperty(this.environment + ".oauth.endpoint");
    }

    private String getAuthVaultEndpoint() {
        return this.properties.getProperty(this.environment + ".users.vault.endpoint");
    }

    private String getAuthVaultToken() {
        return this.properties.getProperty(this.environment + ".users.vault.token");
    }

    private String getAuthVaultPath() {
        return this.properties.getProperty(this.environment + ".users.vault.path");
    }

    private String getAuthVaultKey() {
        return this.properties.getProperty(this.environment + ".users.vault.key");
    }

    private String getAuthClientSecret() {
        return this.properties.getProperty(this.environment + ".oauth.clientSecret");
    }

    private String getAuthClientCode() {
        return this.properties.getProperty(this.environment + ".oauth.clientCode");
    }

    private String getServiceAuthEnabled() {
        return this.properties.getProperty(this.environment + ".oauth.service.authentication");
    }

    private String getServiceAuthClientId() {
        return this.properties.getProperty(this.environment + ".oauth.service.clientId");
    }

    private String getServiceAuthClientCode() {
        return this.properties.getProperty(this.environment + ".oauth.service.clientCode");
    }

    private String getAuthBearerType() {
        return this.properties.getProperty(this.environment + ".oauth.bearer");
    }

    private String getAuthHeaderName() {
        return this.properties.getProperty(this.environment + ".oauth.headerName");
    }

    private String getServiceAuthGrantType() {
        return this.properties.getProperty(this.environment + ".oauth.service.grantType");
    }

    private String getServiceAuthClientSecret() {
        return this.properties.getProperty(this.environment + ".oauth.service.clientSecret");
    }

    private String getEndpoint() {
        return this.properties.getProperty(this.environment + ".endpoint");
    }

    private String getAuthGrantType() {
        return this.properties.getProperty(this.environment + ".oauth.grantType");
    }

    private String getSimId() {
        return this.simulationId;
    }

    String getPackageToScan() {
        return instance.getProperty(PACKAGE_TO_SCAN);
    }

    public static int getMaxConnections() {
        String maxConnection = instance.getConfigHttpMaxConnections();
        return Integer.min(Integer.parseInt(maxConnection), 1000);
    }

    public static int getHttpConnectTimeout() {
        return Integer.parseInt(instance.getConfigHttpConnectTimeout());
    }

    public static int getHttpReadTimeout() {
        return Integer.parseInt(instance.getConfigHttpReadTimeout());
    }

    public static int getHttpHandshakeTimeout() {
        return Integer.parseInt(instance.getConfigHttpHandshakeTimeout());
    }

    public static int getHttpRequestTimeout() {
        return Integer.parseInt(instance.getConfigHttpRequestTimeout());
    }

    public static int getParallelisation() {
        String runnerParallelisation = instance.getRunnerParallelisation();
        int par = Integer.parseInt(runnerParallelisation);
        return Integer.min(par, 1000);
    }

    public static UserSource.SourceType getUserSource() {
        return instance.getUsersSource();
    }

    public static String getServiceEndpoint() {
        return instance.getEndpoint();
    }

    public static String getPackage() {
        return instance.getPackageToScan();
    }

    public static String getClientId() {
        return instance.getAuthClientId();
    }

    public static String getClientSecret() {
        return instance.getAuthClientSecret();
    }

    public static String getClientCode() {
        return instance.getAuthClientCode();
    }

    public static String getGrantType() {
        return instance.getAuthGrantType();
    }

    public static String getApiKey() {
        return instance.getAuthApiKey();
    }

    public static String getAuthServer() {
        return instance.getAuthEndpoint();
    }

    public static String getUserFileSource() {
        return instance.getAuthUserFileSource();
    }

    public static String getInfluxURL() {
        return instance.getDBSupportInfluxURL();
    }

    public static String getInfluxDBName() {
        return instance.getDBSupportInfluxDBName();
    }

    public static String getInfluxUsername() {
        return instance.getDBSupportInfluxUsername();
    }

    public static String getInfluxPassword() {
        return instance.getDBSupportInfluxPassword();
    }

    public static String getVaultEndpoint() {
        return instance.getAuthVaultEndpoint();
    }

    public static String getVaultToken() {
        return instance.getAuthVaultToken();
    }

    public static String getVaultPath() {
        return instance.getAuthVaultPath();
    }

    public static String getNode() {
        return instance.getNodeName();
    }

    public static String getSimulationId() {
        return instance.getSimId();
    }

    public static String getGrafanaEndpoint() {
        return instance.getGrafanaURL();
    }

    public static String getGrafanaToken() {
        return instance.grafanaToken();
    }

    public static String getGrafanaUser() {
        return instance.grafanaUsername();
    }

    public static String getGrafanaPassword() {
        return instance.grafanaPassword();
    }

    public static String getServiceClientId() {
        return instance.getServiceAuthClientId();
    }

    public static String getServiceClientCode() {
        return instance.getServiceAuthClientCode();
    }

    public static String getServiceGrantType() {
        return instance.getServiceAuthGrantType();
    }

    public static String getServiceClientSecret() {
        return instance.getServiceAuthClientSecret();
    }

    public static boolean isServiceAuthenticationEnabled() {
        return "true".equalsIgnoreCase(instance.getServiceAuthEnabled());
    }

    public static String getBearerType() {
        return instance.getAuthBearerType();
    }

    public static String getHeaderName() {
        return instance.getAuthHeaderName();
    }
}

