/*
 * Decompiled with CFR 0.152.
 */
package io.ryos.rhino.sdk.users.source;

import io.ryos.rhino.sdk.SimulationConfig;
import io.ryos.rhino.sdk.exceptions.ExceptionUtils;
import io.ryos.rhino.sdk.users.UserParser;
import io.ryos.rhino.sdk.users.VaultUserParserImpl;
import io.ryos.rhino.sdk.users.data.User;
import io.ryos.rhino.sdk.users.source.UserSource;
import io.ryos.rhino.sdk.users.source.VaultTokenNotFoundException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;

public class VaultUserSourceImpl
implements UserSource {
    private static final String PATH_ROOT_CONTEXT = "v1/secret/data";
    private static final String X_VAULT_TOKEN = "X-Vault-Token";
    private static final String VAULT_TOKEN = "VAULT_TOKEN";
    private final UserParser userParser = new VaultUserParserImpl();

    @Override
    public List<User> getUsers() {
        URI uri = this.getVaultURI();
        String token = Optional.ofNullable(SimulationConfig.getVaultToken()).orElseGet(() -> System.getProperty(VAULT_TOKEN));
        if (token == null) {
            throw new VaultTokenNotFoundException("<env>.auth.vault.token is missing in rhino.properties.");
        }
        Client client = ClientBuilder.newClient();
        Response response = client.target(uri).request().header(X_VAULT_TOKEN, (Object)token).get();
        if (response.getStatus() == Response.Status.OK.getStatusCode()) {
            return this.userParser.unmarshal((InputStream)response.readEntity(InputStream.class));
        }
        return Collections.emptyList();
    }

    @Override
    public List<User> getUsers(int numberOfUsers, String region) {
        if (region != null) {
            return this.getUsers().stream().filter(u -> u.getRegion().equalsIgnoreCase(region)).limit(numberOfUsers).collect(Collectors.toList());
        }
        return this.getUsers().stream().limit(numberOfUsers).collect(Collectors.toList());
    }

    private URI getVaultURI() {
        URI uri = null;
        try {
            uri = UriBuilder.fromUri((URI)new URI(SimulationConfig.getVaultEndpoint())).path(PATH_ROOT_CONTEXT).path(SimulationConfig.getVaultPath()).build(new Object[0]);
        }
        catch (URISyntaxException e) {
            ExceptionUtils.rethrow(e, RuntimeException.class, "<env>.auth.vault.endpoint is missing in rhino.properties.");
        }
        return uri;
    }
}

