/*
 * Decompiled with CFR 0.152.
 */
package io.ryos.rhino.sdk.users.source;

import io.ryos.rhino.sdk.io.ConfigResource;
import io.ryos.rhino.sdk.users.CSVUserParserImpl;
import io.ryos.rhino.sdk.users.UserParser;
import io.ryos.rhino.sdk.users.data.User;
import io.ryos.rhino.sdk.users.source.UserSource;
import java.util.List;
import java.util.stream.Collectors;

public class FileBasedUserSourceImpl
implements UserSource {
    private final String pathToFile;
    private final UserParser parser = new CSVUserParserImpl();

    FileBasedUserSourceImpl(String pathToCSVFile) {
        this.pathToFile = pathToCSVFile;
    }

    @Override
    public List<User> getUsers() {
        List<User> userList = this.parser.unmarshal(new ConfigResource(this.pathToFile).getInputStream());
        if (userList.isEmpty()) {
            throw new RuntimeException("No valid user found in " + this.pathToFile + ". The CSV file should contain lines in the following format: username;password;scope");
        }
        return userList;
    }

    @Override
    public List<User> getUsers(int numberOfUsers, String region) {
        if (!region.equalsIgnoreCase("all")) {
            return this.getUsers().stream().filter(u -> u.getRegion().equalsIgnoreCase(region)).limit(numberOfUsers).collect(Collectors.toList());
        }
        return this.getUsers().stream().limit(numberOfUsers).collect(Collectors.toList());
    }
}

