/*
 * Decompiled with CFR 0.152.
 */
package io.ryos.rhino.sdk.users.repositories;

import io.ryos.rhino.sdk.data.UserSession;
import io.ryos.rhino.sdk.data.UserSessionImpl;
import io.ryos.rhino.sdk.users.data.User;
import io.ryos.rhino.sdk.users.repositories.OAuthAuthenticatorImpl;
import io.ryos.rhino.sdk.users.repositories.UserRepository;
import io.ryos.rhino.sdk.users.source.UserSource;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class OAuthUserRepositoryImpl
implements UserRepository<UserSession> {
    private final long loginDelay;
    private final OAuthAuthenticatorImpl authenticator;
    private final UserSource userSource;

    OAuthUserRepositoryImpl(UserSource userSource, long loginDelay) {
        this.userSource = Objects.requireNonNull(userSource);
        this.authenticator = new OAuthAuthenticatorImpl();
        this.loginDelay = loginDelay;
    }

    @Override
    public List<UserSession> leaseUsers(int numberOfUsers, String region) {
        List<User> users = this.userSource.getUsers(numberOfUsers, region);
        ArrayList<UserSession> result = new ArrayList<UserSession>();
        users.forEach(u -> {
            this.delay();
            UserSessionImpl userSession = new UserSessionImpl(this.authenticator.authenticate((User)u));
            result.add(userSession);
        });
        return result;
    }

    private void delay() {
        try {
            Thread.sleep(this.loginDelay);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

