/*
 * Decompiled with CFR 0.152.
 */
package io.ryos.rhino.sdk.users.repositories;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.ryos.rhino.sdk.SimulationConfig;
import io.ryos.rhino.sdk.exceptions.ExceptionUtils;
import io.ryos.rhino.sdk.exceptions.UserLoginException;
import io.ryos.rhino.sdk.users.OAuthEntity;
import io.ryos.rhino.sdk.users.data.OAuthUser;
import io.ryos.rhino.sdk.users.data.OAuthUserImpl;
import io.ryos.rhino.sdk.users.data.User;
import io.ryos.rhino.sdk.users.repositories.Authenticator;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.Response;

public class OAuthAuthenticatorImpl
implements Authenticator<OAuthUser> {
    private static final String CLIENT_ID = "client_id";
    private static final String CLIENT_SECRET = "client_secret";
    private static final String GRANT_TYPE = "grant_type";
    private static final String USERNAME = "username";
    private static final String PASSWORD = "password";
    private static final String SCOPE = "scope";
    private final ObjectMapper objectMapper = new ObjectMapper();

    @Override
    public OAuthUser authenticate(User user) {
        try {
            Form form = new Form();
            if (SimulationConfig.getClientId() != null) {
                form.param(CLIENT_ID, SimulationConfig.getClientId());
            }
            if (SimulationConfig.getClientSecret() != null) {
                form.param(CLIENT_SECRET, SimulationConfig.getClientSecret());
            }
            if (SimulationConfig.getGrantType() != null) {
                form.param(GRANT_TYPE, SimulationConfig.getGrantType());
            }
            if (user.getScope() != null) {
                form.param(SCOPE, user.getScope());
            }
            if (user.getPassword() != null) {
                form.param(PASSWORD, user.getPassword());
            }
            form.param(USERNAME, user.getUsername());
            Client client = ClientBuilder.newClient();
            Response response = client.target(SimulationConfig.getAuthServer()).request().post(Entity.form((Form)form));
            if (response.getStatus() != Response.Status.OK.getStatusCode()) {
                System.out.println("Cannot login user, status=" + response.getStatus() + ", message=" + (String)response.readEntity(String.class));
                return null;
            }
            String s = (String)response.readEntity(String.class);
            OAuthEntity entity = this.mapToEntity(s);
            return new OAuthUserImpl(user.getUsername(), user.getPassword(), entity.getAccessToken(), entity.getRefreshToken(), user.getScope(), SimulationConfig.getClientId(), user.getId(), user.getRegion());
        }
        catch (Exception e) {
            ExceptionUtils.rethrow(e, UserLoginException.class, "Login failed.");
            return null;
        }
    }

    private OAuthEntity mapToEntity(String s) {
        OAuthEntity o;
        try {
            o = (OAuthEntity)this.objectMapper.readValue(s, OAuthEntity.class);
        }
        catch (Throwable t) {
            throw new RuntimeException("Cannot map authorization server response to entity type: " + OAuthEntity.class.getName(), t);
        }
        return o;
    }
}

