/*
 * Decompiled with CFR 0.152.
 */
package io.ryos.rhino.sdk.users.repositories;

import io.ryos.rhino.sdk.data.UserSession;
import io.ryos.rhino.sdk.data.UserSessionImpl;
import io.ryos.rhino.sdk.users.data.User;
import io.ryos.rhino.sdk.users.repositories.UserRepository;
import io.ryos.rhino.sdk.users.source.UserSource;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.stream.Collectors;

public class DefaultUserRepositoryImpl
implements UserRepository<UserSession> {
    private final Queue<User> users;

    DefaultUserRepositoryImpl(UserSource userSource) {
        Objects.requireNonNull(userSource);
        this.users = new LinkedBlockingQueue<User>(userSource.getUsers());
    }

    @Override
    public List<UserSession> leaseUsers(int numberOfUsers, String region) {
        return this.users.stream().map(UserSessionImpl::new).collect(Collectors.toList());
    }
}

