/*
 * Decompiled with CFR 0.152.
 */
package io.ryos.rhino.sdk.users;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.ryos.rhino.sdk.users.UserParser;
import io.ryos.rhino.sdk.users.data.User;
import io.ryos.rhino.sdk.users.data.UserImpl;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class VaultUserParserImpl
implements UserParser {
    private static final Logger LOG = LogManager.getLogger(VaultUserParserImpl.class);
    private static final String DATA_NODE = "data";
    private static final String KEY_USER = "user";
    private static final String KEY_PASS = "pass";
    private static final String KEY_SCOPE = "scope";
    private final ObjectMapper objectMapper = new ObjectMapper();

    @Override
    public List<User> unmarshal(InputStream inputStream) {
        ArrayList<User> userList = new ArrayList<User>();
        try (InputStream is = inputStream;){
            JsonNode jsonNode = this.objectMapper.readTree(is);
            String key = "users";
            JsonNode path = jsonNode.path(DATA_NODE).path(DATA_NODE).path(key);
            if (!path.isNull() && path.isValueNode()) {
                JsonNode payload = this.objectMapper.readTree(path.textValue());
                Iterator elements = payload.elements();
                boolean id = false;
                while (elements.hasNext()) {
                    JsonNode next = (JsonNode)elements.next();
                    userList.add(new UserImpl(next.get(KEY_USER).textValue(), next.get(KEY_PASS).textValue(), "user-" + UUID.randomUUID(), next.get(KEY_SCOPE).textValue()));
                }
            }
        }
        catch (IOException e) {
            LOG.error((Object)e);
        }
        return userList;
    }
}

