/*
 * Decompiled with CFR 0.152.
 */
package io.ryos.rhino.sdk.specs;

import io.ryos.rhino.sdk.data.Context;
import io.ryos.rhino.sdk.specs.AbstractSpec;
import io.ryos.rhino.sdk.specs.HttpResponse;
import io.ryos.rhino.sdk.specs.HttpSpec;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;

public class HttpSpecImpl
extends AbstractSpec
implements HttpSpec {
    private Supplier<InputStream> toUpload;
    private List<Function<Context, Map.Entry<String, List<String>>>> headers = new ArrayList<Function<Context, Map.Entry<String, List<String>>>>();
    private List<Function<Context, Map.Entry<String, List<String>>>> queryParams = new ArrayList<Function<Context, Map.Entry<String, List<String>>>>();
    private boolean auth;
    private HttpSpec.Method httpMethod;
    private Function<Context, String> endpoint;
    private RetryInfo retryInfo;

    public HttpSpecImpl(String measurement) {
        super(measurement);
    }

    @Override
    public HttpSpec get() {
        this.httpMethod = HttpSpec.Method.GET;
        return this;
    }

    @Override
    public HttpSpec head() {
        this.httpMethod = HttpSpec.Method.HEAD;
        return this;
    }

    @Override
    public HttpSpec put() {
        this.httpMethod = HttpSpec.Method.PUT;
        return this;
    }

    @Override
    public HttpSpec patch() {
        this.httpMethod = HttpSpec.Method.PATCH;
        return this;
    }

    @Override
    public HttpSpec post() {
        this.httpMethod = HttpSpec.Method.POST;
        return this;
    }

    @Override
    public HttpSpec delete() {
        this.httpMethod = HttpSpec.Method.DELETE;
        return this;
    }

    @Override
    public HttpSpec options() {
        this.httpMethod = HttpSpec.Method.OPTIONS;
        return this;
    }

    @Override
    public HttpSpec endpoint(String endpoint) {
        this.endpoint = r -> endpoint;
        return this;
    }

    @Override
    public HttpSpec endpoint(Function<Context, String> endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    @Override
    public HttpSpec header(String key, List<String> values) {
        this.headers.add(e -> Map.entry(key, values));
        return this;
    }

    @Override
    public HttpSpec header(String key, String value) {
        this.headers.add(e -> Map.entry(key, Collections.singletonList(value)));
        return this;
    }

    @Override
    public HttpSpec header(Function<Context, Map.Entry<String, List<String>>> headerFunction) {
        this.headers.add(headerFunction);
        return this;
    }

    @Override
    public HttpSpec auth() {
        this.auth = true;
        return this;
    }

    @Override
    public HttpSpec queryParam(String key, List<String> values) {
        this.queryParams.add(e -> Map.entry(key, values));
        return this;
    }

    @Override
    public HttpSpec queryParam(String key, String value) {
        this.queryParams.add(e -> Map.entry(key, Collections.singletonList(value)));
        return this;
    }

    @Override
    public HttpSpec queryParam(Function<Context, Map.Entry<String, List<String>>> headerFunction) {
        this.queryParams.add(headerFunction);
        return this;
    }

    @Override
    public HttpSpec upload(Supplier<InputStream> inputStream) {
        this.toUpload = inputStream;
        return this;
    }

    @Override
    public HttpSpec retryIf(Predicate<HttpResponse> predicate, int numOfRetries) {
        this.retryInfo = new RetryInfo(predicate, numOfRetries);
        return this;
    }

    @Override
    public Supplier<InputStream> getUploadContent() {
        return this.toUpload;
    }

    @Override
    public HttpSpec.Method getMethod() {
        return this.httpMethod;
    }

    @Override
    public List<Function<Context, Map.Entry<String, List<String>>>> getHeaders() {
        return this.headers;
    }

    @Override
    public List<Function<Context, Map.Entry<String, List<String>>>> getQueryParameters() {
        return this.queryParams;
    }

    @Override
    public Function<Context, String> getEndpoint() {
        return this.endpoint;
    }

    @Override
    public boolean isAuth() {
        return this.auth;
    }

    @Override
    public RetryInfo getRetryInfo() {
        return this.retryInfo;
    }

    public static class RetryInfo {
        private Predicate<HttpResponse> predicate;
        private int numOfRetries;

        RetryInfo(Predicate<HttpResponse> predicate, int numOfRetries) {
            this.predicate = predicate;
            this.numOfRetries = numOfRetries;
        }

        public Predicate<HttpResponse> getPredicate() {
            return this.predicate;
        }

        public int getNumOfRetries() {
            return this.numOfRetries;
        }
    }
}

