/*
 * Decompiled with CFR 0.152.
 */
package io.ryos.rhino.sdk.specs;

import io.netty.handler.codec.http.HttpHeaders;
import io.ryos.rhino.sdk.reporting.MeasurementImpl;
import io.ryos.rhino.sdk.reporting.UserEvent;
import io.ryos.rhino.sdk.runners.EventDispatcher;
import org.asynchttpclient.AsyncHandler;
import org.asynchttpclient.HttpResponseBodyPart;
import org.asynchttpclient.HttpResponseStatus;
import org.asynchttpclient.Response;
import org.asynchttpclient.netty.request.NettyRequest;

public class HttpSpecAsyncHandler
implements AsyncHandler<Response> {
    private final String stepName;
    private final String specName;
    private final String userId;
    private final MeasurementImpl measurement;
    private volatile long start = -1L;
    private volatile int status;
    private final Response.ResponseBuilder builder = new Response.ResponseBuilder();
    private final EventDispatcher eventDispatcher;

    public HttpSpecAsyncHandler(String userId, String specName, String stepName, EventDispatcher eventDispatcher) {
        this.measurement = new MeasurementImpl(specName, userId);
        this.specName = specName;
        this.userId = userId;
        this.stepName = stepName;
        this.eventDispatcher = eventDispatcher;
    }

    public AsyncHandler.State onStatusReceived(HttpResponseStatus responseStatus) {
        this.builder.reset();
        this.builder.accumulate(responseStatus);
        this.status = responseStatus.getStatusCode();
        return AsyncHandler.State.CONTINUE;
    }

    public AsyncHandler.State onHeadersReceived(HttpHeaders headers) {
        this.builder.accumulate(headers);
        return AsyncHandler.State.CONTINUE;
    }

    public AsyncHandler.State onBodyPartReceived(HttpResponseBodyPart bodyPart) {
        this.builder.accumulate(bodyPart);
        return AsyncHandler.State.CONTINUE;
    }

    public void onThrowable(Throwable t) {
    }

    public Response onCompleted() {
        long elapsed = System.currentTimeMillis() - this.start;
        this.measurement.measure(this.stepName, String.valueOf(this.status));
        UserEvent userEventEnd = new UserEvent();
        userEventEnd.elapsed = elapsed;
        userEventEnd.start = this.start;
        userEventEnd.end = this.start + elapsed;
        userEventEnd.scenario = this.specName;
        userEventEnd.eventType = UserEvent.EventType.END;
        userEventEnd.id = this.userId;
        this.measurement.record(userEventEnd);
        this.eventDispatcher.dispatchEvents(this.measurement);
        return this.builder.build();
    }

    public void onRequestSend(NettyRequest request) {
        this.start = System.currentTimeMillis();
        UserEvent userEventStart = new UserEvent();
        userEventStart.elapsed = 0L;
        userEventStart.start = this.start;
        userEventStart.end = this.start;
        userEventStart.scenario = this.specName;
        userEventStart.eventType = UserEvent.EventType.START;
        userEventStart.id = this.userId;
        this.measurement.record(userEventStart);
    }
}

