/*
 * Decompiled with CFR 0.152.
 */
package io.ryos.rhino.sdk.runners;

import com.google.common.base.Preconditions;
import java.time.Duration;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.function.Tuple2;

public class Rampup {
    private static final Logger LOG = LoggerFactory.getLogger(Rampup.class);

    public static <T> Function<Flux<T>, Flux<T>> rampup(long startRps, long targetRps, Duration duration) {
        Preconditions.checkArgument((startRps > 0L ? 1 : 0) != 0, (Object)"startRps <= 0");
        Preconditions.checkArgument((targetRps > 1L ? 1 : 0) != 0, (Object)"targetRps < 1");
        Objects.requireNonNull(duration, "duration is null");
        double slope = Math.abs((double)(targetRps - startRps) / (double)duration.toSeconds());
        long startTime = System.currentTimeMillis();
        Flux rampup = Flux.generate(sink -> sink.next((Object)0L)).delayUntil(d -> {
            long t = (System.currentTimeMillis() - startTime) / 1000L;
            long rps = targetRps;
            if (t <= duration.toSeconds()) {
                rps = (long)Math.floor((double)startRps + slope * (double)t);
            }
            long tickNano = (long)Math.floor(1.0 / (double)rps * 1.0E9);
            LOG.debug("tickNano={}, rps={}, t={}", new Object[]{tickNano, rps, t});
            return Mono.delay((Duration)Duration.ofNanos(tickNano));
        });
        UnaryOperator res = f -> f.zipWith((Publisher)rampup.concatWith((Publisher)Flux.generate(sink -> sink.next((Object)0L)))).map(Tuple2::getT1);
        return res;
    }
}

