/*
 * Decompiled with CFR 0.152.
 */
package io.ryos.rhino.sdk.runners;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.Terminated;
import akka.dispatch.OnComplete;
import akka.pattern.Patterns;
import io.ryos.rhino.sdk.SimulationMetadata;
import io.ryos.rhino.sdk.io.InfluxDBWriter;
import io.ryos.rhino.sdk.io.SimulationLogWriter;
import io.ryos.rhino.sdk.reporting.GatlingLogFormatter;
import io.ryos.rhino.sdk.reporting.MeasurementImpl;
import io.ryos.rhino.sdk.reporting.StdoutReporter;
import java.time.Instant;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import scala.Function1;
import scala.concurrent.Await;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;

public class EventDispatcher {
    private static final Logger LOG = LogManager.getLogger(EventDispatcher.class);
    private static final long TERMINATION_REQUEST_TIMEOUT = 5000L;
    private static final String ACTOR_SYS_NAME = "rhino-dispatcher";
    private SimulationMetadata simulationMetadata;
    private ActorRef loggerActor;
    private ActorRef influxActor;
    private ActorRef stdOutReptorter;
    private ActorSystem system = ActorSystem.create((String)"rhino-dispatcher");

    public EventDispatcher(SimulationMetadata simulationMetadata) {
        this.simulationMetadata = Objects.requireNonNull(simulationMetadata);
        this.stdOutReptorter = this.system.actorOf(StdoutReporter.props(simulationMetadata.getNumberOfUsers(), Instant.now(), simulationMetadata.getDuration()), StdoutReporter.class.getName());
        this.loggerActor = this.system.actorOf(SimulationLogWriter.props(simulationMetadata.getReportingURI(), simulationMetadata.getLogFormatter()), SimulationLogWriter.class.getName());
        if (simulationMetadata.isEnableInflux()) {
            this.influxActor = this.system.actorOf(InfluxDBWriter.props(), InfluxDBWriter.class.getName());
        }
        if (simulationMetadata.getLogFormatter() instanceof GatlingLogFormatter) {
            this.loggerActor.tell((Object)String.format("RUN\t%s\t%s\t%s\trhino\t%s\n", simulationMetadata.getSimulationClass().getName(), simulationMetadata.getSimulationName(), System.currentTimeMillis(), "3.0.0-RC4"), ActorRef.noSender());
        }
    }

    public void dispatchEvents(MeasurementImpl measurement) {
        measurement.getEvents().forEach(e -> {
            this.loggerActor.tell(e, ActorRef.noSender());
            this.stdOutReptorter.tell(e, ActorRef.noSender());
            if (this.simulationMetadata.isEnableInflux()) {
                this.influxActor.tell(e, ActorRef.noSender());
            }
        });
    }

    public void stop() {
        this.requestForTermination();
        Future terminate = this.system.terminate();
        terminate.onComplete((Function1)new OnComplete<Terminated>(){

            public void onComplete(Throwable throwable, Terminated terminated) {
                EventDispatcher.this.system = null;
            }
        }, (ExecutionContext)this.system.dispatcher());
    }

    private void requestForTermination() {
        Future ask = Patterns.ask((ActorRef)this.stdOutReptorter, (Object)new StdoutReporter.EndTestEvent(Instant.now()), (long)5000L);
        try {
            Await.result((Awaitable)ask, (Duration)FiniteDuration.Inf());
        }
        catch (Exception e) {
            LOG.debug((Object)e);
        }
    }
}

