/*
 * Decompiled with CFR 0.152.
 */
package io.ryos.rhino.sdk.runners;

import io.ryos.rhino.sdk.CyclicIterator;
import io.ryos.rhino.sdk.SimulationConfig;
import io.ryos.rhino.sdk.SimulationMetadata;
import io.ryos.rhino.sdk.data.Context;
import io.ryos.rhino.sdk.data.Scenario;
import io.ryos.rhino.sdk.data.UserSession;
import io.ryos.rhino.sdk.io.Out;
import io.ryos.rhino.sdk.monitoring.GrafanaGateway;
import io.ryos.rhino.sdk.runners.DefaultRunnerSimulationInjector;
import io.ryos.rhino.sdk.runners.DefaultSimulationCallable;
import io.ryos.rhino.sdk.runners.EventDispatcher;
import io.ryos.rhino.sdk.runners.SimulationRunner;
import io.ryos.rhino.sdk.users.repositories.CyclicUserSessionRepositoryImpl;
import io.ryos.rhino.sdk.users.repositories.UserRepository;
import io.ryos.rhino.sdk.utils.ReflectionUtils;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.stream.Stream;
import org.reactivestreams.Publisher;
import reactor.core.Disposable;
import reactor.core.publisher.Flux;
import reactor.core.scheduler.Schedulers;

public class DefaultSimulationRunner
implements SimulationRunner {
    private static final String JOB = "job";
    private static final long ONE_SEC = 1000L;
    private static final long MAX_WAIT_FOR_USER = 60L;
    private final SimulationMetadata simulationMetadata;
    private final CyclicIterator<Scenario> scenarioCyclicIterator;
    private final ScheduledExecutorService scheduler;
    private final EventDispatcher eventDispatcher;
    private volatile boolean shutdownInitiated;
    private volatile Disposable subscribe;

    public DefaultSimulationRunner(Context context) {
        this.simulationMetadata = (SimulationMetadata)context.get(JOB).orElseThrow();
        this.scenarioCyclicIterator = new CyclicIterator<Scenario>(this.simulationMetadata.getScenarios());
        this.scheduler = Executors.newSingleThreadScheduledExecutor();
        this.eventDispatcher = new EventDispatcher(this.simulationMetadata);
    }

    @Override
    public void start() {
        Out.info("Starting load test for " + this.simulationMetadata.getDuration().toMinutes() + " minutes ...");
        UserRepository<UserSession> userRepository = this.simulationMetadata.getUserRepository();
        CyclicUserSessionRepositoryImpl userSessionProvider = new CyclicUserSessionRepositoryImpl(userRepository, this.simulationMetadata.getUserRegion(), this.simulationMetadata.getNumberOfUsers());
        if (SimulationConfig.isGrafanaEnabled()) {
            this.setUpGrafanaDashboard();
        }
        this.prepareUserSessions();
        new DefaultRunnerSimulationInjector(this.simulationMetadata, null).injectOn(this.simulationMetadata.getTestInstance());
        Stream<UserSession> users = Stream.generate(userSessionProvider::take);
        Stream<Scenario> scenarios = Stream.generate(this.scenarioCyclicIterator::next);
        this.subscribe = Flux.zip((Publisher)Flux.fromStream(users), (Publisher)Flux.fromStream(scenarios)).take(this.simulationMetadata.getDuration()).parallel(SimulationConfig.getParallelisation()).runOn(Schedulers.elastic()).doOnTerminate(this::notifyAwaiting).doOnNext(t -> new DefaultSimulationCallable(this.simulationMetadata, (UserSession)t.getT1(), (Scenario)t.getT2(), this.eventDispatcher).call()).subscribe();
        this.await();
        this.stop();
    }

    private void setUpGrafanaDashboard() {
        Out.info("Grafana is enabled. Creating dashboard: " + SimulationConfig.getSimulationId());
        new GrafanaGateway().setUpDashboard(SimulationConfig.getSimulationId(), (String[])this.simulationMetadata.getScenarios().stream().map(Scenario::getDescription).toArray(String[]::new));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void await() {
        DefaultSimulationRunner defaultSimulationRunner = this;
        synchronized (defaultSimulationRunner) {
            try {
                this.wait(this.simulationMetadata.getDuration().toMillis() + 1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyAwaiting() {
        DefaultSimulationRunner defaultSimulationRunner = this;
        synchronized (defaultSimulationRunner) {
            this.notify();
        }
    }

    @Override
    public void stop() {
        System.out.println("Someone pushed the stop() button on runner.");
        this.shutdown();
    }

    private void shutdown() {
        if (this.shutdownInitiated) {
            return;
        }
        this.shutdownInitiated = true;
        System.out.println("Stopping the simulation...");
        this.subscribe.dispose();
        System.out.println("Cleaning up.");
        UserRepository<UserSession> userRepository = this.simulationMetadata.getUserRepository();
        this.cleanupUserSessions();
        System.out.println("Shutting down the system ...");
        this.scenarioCyclicIterator.stop();
        this.eventDispatcher.stop();
        System.out.println("Shutting down the scheduler ...");
        this.scheduler.shutdown();
        int retry = 0;
        while (!this.scheduler.isShutdown() && ++retry < 5) {
            this.waitForASec();
        }
        this.scheduler.shutdownNow();
        System.out.println("Shutting down completed ...");
        System.out.println("Bye!");
    }

    private void waitForASec() {
        System.out.println("Wait ...");
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void prepareUserSessions() {
        if (this.simulationMetadata.getPrepareMethod() != null) {
            ReflectionUtils.executeMethod(this.simulationMetadata.getPrepareMethod(), this.simulationMetadata.getTestInstance(), new Object[0]);
        }
    }

    private void cleanupUserSessions() {
        if (this.simulationMetadata.getCleanupMethod() != null) {
            ReflectionUtils.executeMethod(this.simulationMetadata.getCleanupMethod(), this.simulationMetadata.getTestInstance(), new Object[0]);
        }
    }
}

