/*
 * Decompiled with CFR 0.152.
 */
package io.ryos.rhino.sdk.runners;

import io.ryos.rhino.sdk.SimulationMetadata;
import io.ryos.rhino.sdk.data.Scenario;
import io.ryos.rhino.sdk.data.UserSession;
import io.ryos.rhino.sdk.reporting.Measurement;
import io.ryos.rhino.sdk.reporting.MeasurementImpl;
import io.ryos.rhino.sdk.reporting.UserEvent;
import io.ryos.rhino.sdk.runners.EventDispatcher;
import io.ryos.rhino.sdk.users.data.User;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.concurrent.Callable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DefaultSimulationCallable
implements Callable<Measurement> {
    private static final Logger LOG = LogManager.getLogger(DefaultSimulationCallable.class);
    private final SimulationMetadata simulationMetadata;
    private final UserSession userSession;
    private final Scenario scenario;
    private final EventDispatcher eventDispatcher;

    DefaultSimulationCallable(SimulationMetadata simulationMetadata, UserSession userSession, Scenario scenario, EventDispatcher eventDispatcher) {
        this.simulationMetadata = Objects.requireNonNull(simulationMetadata);
        this.userSession = Objects.requireNonNull(userSession);
        this.scenario = Objects.requireNonNull(scenario);
        this.eventDispatcher = Objects.requireNonNull(eventDispatcher);
    }

    @Override
    public Measurement call() {
        User user = this.userSession.getUser();
        this.executeMethod(this.simulationMetadata.getBeforeMethod(), this.simulationMetadata.getTestInstance(), this.userSession);
        MeasurementImpl measurement = new MeasurementImpl(this.scenario.getDescription(), user.getId());
        long start = System.currentTimeMillis();
        UserEvent userEventStart = new UserEvent();
        userEventStart.elapsed = 0L;
        userEventStart.start = start;
        userEventStart.end = start;
        userEventStart.scenario = this.scenario.getDescription();
        userEventStart.eventType = UserEvent.EventType.START;
        userEventStart.id = user.getId();
        measurement.record(userEventStart);
        this.executeScenario(this.scenario, measurement, this.simulationMetadata.getTestInstance(), this.userSession);
        long elapsed = System.currentTimeMillis() - start;
        UserEvent userEventEnd = new UserEvent();
        userEventEnd.elapsed = elapsed;
        userEventEnd.start = start;
        userEventEnd.end = start + elapsed;
        userEventEnd.scenario = this.scenario.getDescription();
        userEventEnd.eventType = UserEvent.EventType.END;
        userEventEnd.id = user.getId();
        measurement.record(userEventEnd);
        this.eventDispatcher.dispatchEvents(measurement);
        this.executeMethod(this.simulationMetadata.getAfterMethod(), this.simulationMetadata.getTestInstance(), this.userSession);
        return measurement;
    }

    private void executeScenario(Scenario scenario, MeasurementImpl measurement, Object simulationInstance, UserSession userSession) {
        block6: {
            try {
                Method method = scenario.getMethod();
                Class<?>[] parameterTypes = method.getParameterTypes();
                if (parameterTypes.length == 0) {
                    method.invoke(simulationInstance, new Object[0]);
                    break block6;
                }
                if (parameterTypes.length == 2 && parameterTypes[0].isAssignableFrom(Measurement.class) && parameterTypes[1].isAssignableFrom(UserSession.class)) {
                    method.invoke(simulationInstance, measurement, userSession);
                    break block6;
                }
                if (parameterTypes.length == 1 && parameterTypes[0].isAssignableFrom(Measurement.class)) {
                    method.invoke(simulationInstance, measurement);
                    break block6;
                }
                if (parameterTypes.length == 1 && parameterTypes[0].isAssignableFrom(UserSession.class)) {
                    method.invoke(simulationInstance, userSession);
                    break block6;
                }
                throw new IllegalAccessException("No proper scenario method found.");
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                LOG.error(e.getCause().getMessage());
                throw new RuntimeException(e.getCause());
            }
        }
    }

    private void executeMethod(Method method, Object simulationInstance, UserSession userSession) {
        block4: {
            try {
                if (method == null) break block4;
                Class<?>[] parameterTypes = method.getParameterTypes();
                if (parameterTypes.length == 1 && parameterTypes[0].isAssignableFrom(UserSession.class)) {
                    method.invoke(simulationInstance, userSession);
                    break block4;
                }
                if (parameterTypes.length == 0) {
                    method.invoke(simulationInstance, new Object[0]);
                    break block4;
                }
                throw new IllegalAccessException("No proper scenario method found.");
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                LOG.error(e.getCause().getMessage());
                throw new RuntimeException("Cannot invoke the method with step: " + method.getName() + "()", e);
            }
        }
    }
}

