/*
 * Decompiled with CFR 0.152.
 */
package io.ryos.rhino.sdk.monitoring;

import io.ryos.rhino.sdk.SimulationConfig;
import io.ryos.rhino.sdk.exceptions.ExceptionUtils;
import io.ryos.rhino.sdk.monitoring.GrafanaSetupException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.stream.Collectors;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.Response;

public class GrafanaGateway {
    private static final String GRAFANA_DASHBOARD_TEMPLATE = "/grafana/dashboard.json";
    private static final String TARGET = SimulationConfig.getGrafanaEndpoint() + "/api/dashboards/db";
    private static final String HEADER_AUTHORIZATION = "Authorization";

    public void setUpDashboard(String simulationName, String ... scenarios) {
        InputStream resourceAsStream = this.getClass().getResourceAsStream(GRAFANA_DASHBOARD_TEMPLATE);
        if (resourceAsStream != null) {
            Response createDashboardResponse;
            String dbTemplate = this.getDashboardCode(simulationName, resourceAsStream, scenarios);
            Invocation.Builder request = ClientBuilder.newClient().target(this.getUri()).request();
            if (this.getStrippedToken() != null) {
                request = request.header(HEADER_AUTHORIZATION, (Object)("Bearer " + this.getStrippedToken()));
            }
            if ((createDashboardResponse = request.post(Entity.entity((Object)dbTemplate, (String)"application/json"))).getStatus() != Response.Status.OK.getStatusCode() && createDashboardResponse.getStatus() != Response.Status.PRECONDITION_FAILED.getStatusCode()) {
                throw new GrafanaSetupException("Server response was : " + createDashboardResponse.getStatus());
            }
        }
    }

    private String getStrippedToken() {
        String grafanaToken = SimulationConfig.getGrafanaToken();
        if (grafanaToken == null || grafanaToken.length() == 0) {
            return null;
        }
        if (grafanaToken.length() < 2) {
            throw new RuntimeException("Invalid Grafana token.");
        }
        return SimulationConfig.getGrafanaToken().substring(1, SimulationConfig.getGrafanaToken().length() - 1);
    }

    private String getDashboardCode(String simulationName, InputStream resourceAsStream, String[] scenarios) {
        String dbTemplate = "";
        try (BufferedReader br = new BufferedReader(new InputStreamReader(resourceAsStream, Charset.defaultCharset()));){
            dbTemplate = br.lines().collect(Collectors.joining(System.lineSeparator()));
            dbTemplate = dbTemplate.replace("${SIMULATION_NAME}", simulationName);
            if (scenarios != null && scenarios.length > 0) {
                dbTemplate = dbTemplate.replace("${SCENARIO_1}", scenarios[0]);
            }
        }
        catch (IOException ioe) {
            ExceptionUtils.rethrow(ioe, GrafanaSetupException.class, "Cannot read Grafana dashboard template.");
        }
        return dbTemplate;
    }

    private URI getUri() {
        try {
            return new URI(TARGET);
        }
        catch (URISyntaxException e) {
            ExceptionUtils.rethrow(e, GrafanaSetupException.class);
            return null;
        }
    }
}

