/*
 * Decompiled with CFR 0.152.
 */
package io.ryos.rhino.sdk.io;

import akka.actor.AbstractActor;
import akka.actor.Props;
import akka.japi.Creator;
import akka.japi.pf.ReceiveBuilder;
import io.ryos.rhino.sdk.io.ResultWriter;
import io.ryos.rhino.sdk.reporting.LogEvent;
import io.ryos.rhino.sdk.reporting.LogFormatter;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SimulationLogWriter
extends AbstractActor
implements ResultWriter {
    private static final Logger LOG = LogManager.getLogger(SimulationLogWriter.class);
    private LogFormatter logFormatter;
    private Writer writer;

    public static <T extends LogFormatter> Props props(String pathToLogFile, T logFormatter) {
        return Props.create(SimulationLogWriter.class, (Creator & Serializable)() -> new SimulationLogWriter(pathToLogFile, logFormatter));
    }

    public SimulationLogWriter(String logFile, LogFormatter formatter) {
        if (formatter == null) {
            return;
        }
        this.logFormatter = formatter;
        try {
            this.writer = new BufferedWriter(new FileWriter(new File(Objects.requireNonNull(logFile))));
        }
        catch (IOException e) {
            LOG.error((Object)e);
        }
    }

    public void write(LogEvent report) {
        if (this.logFormatter != null) {
            this.write(this.logFormatter.format(report));
        }
    }

    @Override
    public void write(String report) {
        try {
            this.writer.write(report);
            this.writer.flush();
        }
        catch (IOException e) {
            LOG.error((Object)e);
        }
    }

    @Override
    public void close() {
    }

    public AbstractActor.Receive createReceive() {
        return ReceiveBuilder.create().match(String.class, this::write).match(LogEvent.class, this::write).build();
    }
}

