/*
 * Decompiled with CFR 0.152.
 */
package io.ryos.rhino.sdk.io;

import akka.actor.AbstractActor;
import akka.actor.Props;
import akka.japi.pf.ReceiveBuilder;
import io.ryos.rhino.sdk.SimulationConfig;
import io.ryos.rhino.sdk.io.ResultWriter;
import io.ryos.rhino.sdk.reporting.LogEvent;
import io.ryos.rhino.sdk.reporting.ScenarioEvent;
import io.ryos.rhino.sdk.reporting.UserEvent;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.influxdb.InfluxDB;
import org.influxdb.InfluxDBFactory;
import org.influxdb.dto.BatchPoints;
import org.influxdb.dto.Point;

public class InfluxDBWriter
extends AbstractActor
implements ResultWriter<LogEvent> {
    private static final String DEFAULT_DB = "rhino_test_db_";
    private final InfluxDB influxDB;
    private final String dbName = Optional.ofNullable(SimulationConfig.getInfluxDBName()).orElse("rhino_test_db_" + System.currentTimeMillis());

    public static <T extends InfluxDBWriter> Props props() {
        return Props.create(InfluxDBWriter.class, InfluxDBWriter::new);
    }

    private InfluxDBWriter() {
        this.influxDB = InfluxDBFactory.connect((String)SimulationConfig.getInfluxURL()).setLogLevel(InfluxDB.LogLevel.NONE).setConsistency(InfluxDB.ConsistencyLevel.ONE).enableBatch(100, 200, TimeUnit.MICROSECONDS);
        this.influxDB.createDatabase(this.dbName);
    }

    public AbstractActor.Receive createReceive() {
        return ReceiveBuilder.create().match(String.class, this::write).match(LogEvent.class, this::write).build();
    }

    @Override
    public void write(LogEvent logEvent) {
        if (logEvent instanceof ScenarioEvent) {
            this.createPoint((ScenarioEvent)logEvent);
        }
        if (logEvent instanceof UserEvent) {
            this.createPoint((UserEvent)logEvent);
        }
    }

    private void createPoint(ScenarioEvent report) {
        BatchPoints batchPoints = BatchPoints.database((String)this.dbName).consistency(InfluxDB.ConsistencyLevel.ALL).build();
        Point.Builder builder = Point.measurement((String)("simulation_" + SimulationConfig.getSimulationId())).tag("step", report.step).addField("scenario", report.scenario).addField("status", report.status).addField("pt", report.elapsed).addField("node", SimulationConfig.getNode());
        batchPoints.point(builder.build());
        this.influxDB.write(batchPoints);
    }

    private void createPoint(UserEvent report) {
        if (report.eventType == UserEvent.EventType.END) {
            BatchPoints batchPoints = BatchPoints.database((String)this.dbName).consistency(InfluxDB.ConsistencyLevel.ALL).build();
            Point.Builder builder = Point.measurement((String)("user_" + SimulationConfig.getSimulationId())).tag("scenario", report.scenario).addField("id", report.id).addField("node", SimulationConfig.getNode()).addField("pt", report.elapsed);
            batchPoints.point(builder.build());
            this.influxDB.write(batchPoints);
        }
    }

    @Override
    public void write(String report) {
        System.out.println("string");
    }

    @Override
    public void close() {
    }
}

