/*
 * Decompiled with CFR 0.152.
 */
package io.ryos.rhino.sdk.dsl;

import io.ryos.rhino.sdk.data.UserSession;
import io.ryos.rhino.sdk.dsl.SpecMaterializer;
import io.ryos.rhino.sdk.reporting.MeasurementImpl;
import io.ryos.rhino.sdk.reporting.UserEvent;
import io.ryos.rhino.sdk.runners.EventDispatcher;
import io.ryos.rhino.sdk.specs.SomeSpec;
import reactor.core.publisher.Mono;

public class SomeSpecMaterializer
implements SpecMaterializer<SomeSpec, UserSession> {
    private final EventDispatcher dispatcher;

    public SomeSpecMaterializer(EventDispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }

    @Override
    public Mono<UserSession> materialize(SomeSpec spec, UserSession userSession) {
        String userId = userSession.getUser().getId();
        return Mono.fromCallable(() -> {
            MeasurementImpl measurement = new MeasurementImpl(spec.getTestName(), userId);
            long start = System.currentTimeMillis();
            UserEvent userEventStart = new UserEvent();
            userEventStart.elapsed = 0L;
            userEventStart.start = start;
            userEventStart.end = start;
            userEventStart.scenario = spec.getTestName();
            userEventStart.eventType = UserEvent.EventType.START;
            userEventStart.id = userSession.getUser().getId();
            measurement.record(userEventStart);
            UserSession resultingSession = spec.getFunction().apply(userSession, measurement);
            long elapsed = System.currentTimeMillis() - start;
            UserEvent userEventEnd = new UserEvent();
            userEventEnd.elapsed = elapsed;
            userEventEnd.start = start;
            userEventEnd.end = start + elapsed;
            userEventEnd.scenario = spec.getTestName();
            userEventEnd.eventType = UserEvent.EventType.END;
            userEventEnd.id = userId;
            measurement.record(userEventEnd);
            this.dispatcher.dispatchEvents(measurement);
            return resultingSession;
        });
    }
}

