/*
 * Decompiled with CFR 0.152.
 */
package io.ryos.rhino.sdk.dsl;

import io.ryos.rhino.sdk.data.UserSession;
import io.ryos.rhino.sdk.dsl.LoadDsl;
import io.ryos.rhino.sdk.specs.ConditionalSpecWrapper;
import io.ryos.rhino.sdk.specs.Spec;
import io.ryos.rhino.sdk.specs.WaitSpecImpl;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;

public class ConnectableDsl
implements LoadDsl {
    private Duration pause;
    private String testName;
    private final List<Spec> executableFunctions = new ArrayList<Spec>();

    @Override
    public ConnectableDsl wait(Duration duration) {
        this.executableFunctions.add(new WaitSpecImpl(duration));
        return this;
    }

    @Override
    public ConnectableDsl run(Spec spec) {
        this.executableFunctions.add(spec);
        return this;
    }

    @Override
    public ConnectableDsl runIf(Predicate<UserSession> predicate, Spec spec) {
        this.executableFunctions.add(new ConditionalSpecWrapper(spec, predicate));
        return this;
    }

    public LoadDsl withName(String testName) {
        this.executableFunctions.forEach(s -> s.setTestName(testName));
        this.testName = testName;
        return this;
    }

    public String getName() {
        return this.testName;
    }

    public List<Spec> getSpecs() {
        return this.executableFunctions;
    }
}

