/*
 * Decompiled with CFR 0.152.
 */
package io.ryos.rhino.sdk;

import io.ryos.rhino.sdk.RampupInfo;
import io.ryos.rhino.sdk.ThrottlingInfo;
import io.ryos.rhino.sdk.annotations.Logging;
import io.ryos.rhino.sdk.data.Scenario;
import io.ryos.rhino.sdk.data.UserSession;
import io.ryos.rhino.sdk.dsl.LoadDsl;
import io.ryos.rhino.sdk.reporting.LogFormatter;
import io.ryos.rhino.sdk.runners.SimulationRunner;
import io.ryos.rhino.sdk.users.repositories.UserRepository;
import io.ryos.rhino.sdk.utils.ReflectionUtils;
import java.lang.reflect.Method;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SimulationMetadata {
    private static final String ACTOR_SYS_NAME = "benchmark";
    private static final Logger LOG = LogManager.getLogger(SimulationMetadata.class);
    private Class<? extends SimulationRunner> runner;
    private String simulationName;
    private Duration duration;
    private int numberOfUsers;
    private String userRegion;
    private ThrottlingInfo throttlingInfo;
    private RampupInfo rampUpInfo;
    private Class simulationClass;
    private Object testInstance;
    private Supplier<Object> simulationInstanceFactory = () -> ReflectionUtils.instanceOf(this.simulationClass).orElseThrow();
    private List<Scenario> scenarios;
    private List<LoadDsl> specs;
    private Method beforeMethod;
    private Method afterMethod;
    private Method prepareMethod;
    private Method cleanupMethod;
    private UserRepository<UserSession> userRepository;
    private boolean enableInflux;
    private String reportingURI;

    private SimulationMetadata(Builder builder) {
        this.duration = builder.duration;
        this.simulationName = builder.simulation;
        this.testInstance = builder.testInstance;
        this.numberOfUsers = builder.injectUser;
        this.rampUpInfo = builder.rampUpInfo;
        this.simulationClass = builder.simulationClass;
        this.scenarios = builder.scenarios;
        this.specs = builder.specs;
        this.prepareMethod = builder.prepareMethod;
        this.cleanupMethod = builder.cleanUpMethod;
        this.beforeMethod = builder.beforeMethod;
        this.afterMethod = builder.afterMethod;
        this.userRepository = builder.userRepository;
        this.enableInflux = builder.enableInflux;
        this.runner = builder.runner;
        this.reportingURI = builder.reportingURI;
        this.throttlingInfo = builder.throttlingInfo;
        this.userRegion = builder.userRegion;
    }

    public LogFormatter getLogFormatter() {
        Optional<Logging> loggingAnnotation = ReflectionUtils.getClassLevelAnnotation(this.simulationClass, Logging.class);
        Logging logging = loggingAnnotation.orElseGet(() -> null);
        if (logging == null) {
            return null;
        }
        Optional<? extends LogFormatter> logFormatterInstance = ReflectionUtils.instanceOf(logging.formatter());
        return logFormatterInstance.orElseThrow(RuntimeException::new);
    }

    public Method getPrepareMethod() {
        return this.prepareMethod;
    }

    public Method getCleanupMethod() {
        return this.cleanupMethod;
    }

    public String getReportingURI() {
        return this.reportingURI;
    }

    public Class<? extends SimulationRunner> getRunner() {
        return this.runner;
    }

    public int getNumberOfUsers() {
        return this.numberOfUsers;
    }

    public UserRepository<UserSession> getUserRepository() {
        return this.userRepository;
    }

    public Duration getDuration() {
        return this.duration;
    }

    public List<Scenario> getScenarios() {
        return this.scenarios;
    }

    public List<LoadDsl> getSpecs() {
        return this.specs;
    }

    public Class getSimulationClass() {
        return this.simulationClass;
    }

    public boolean isEnableInflux() {
        return this.enableInflux;
    }

    public Method getBeforeMethod() {
        return this.beforeMethod;
    }

    public Method getAfterMethod() {
        return this.afterMethod;
    }

    public String getSimulationName() {
        return this.simulationName;
    }

    public Object getTestInstance() {
        return this.testInstance;
    }

    public ThrottlingInfo getThrottlingInfo() {
        return this.throttlingInfo;
    }

    public RampupInfo getRampUpInfo() {
        return this.rampUpInfo;
    }

    public String getUserRegion() {
        return this.userRegion;
    }

    static class Builder {
        private String simulation;
        private int injectUser;
        private RampupInfo rampUpInfo;
        private ThrottlingInfo throttlingInfo;
        private Class<?> simulationClass;
        private Object testInstance;
        private Class<? extends SimulationRunner> runner;
        private List<Scenario> scenarios;
        private List<LoadDsl> specs;
        private Method prepareMethod;
        private Method cleanUpMethod;
        private Method beforeMethod;
        private Method afterMethod;
        private UserRepository<UserSession> userRepository;
        private String userRegion;
        private String reportingURI;
        private String logFormatter;
        private Duration duration;
        private boolean enableInflux;

        Builder() {
        }

        public Builder withInflux(boolean enableInflux) {
            this.enableInflux = enableInflux;
            return this;
        }

        public Builder withSimulation(String simulation) {
            this.simulation = simulation;
            return this;
        }

        public Builder withInjectUser(int injectUser) {
            this.injectUser = injectUser;
            return this;
        }

        public Builder withRampUp(RampupInfo rampUp) {
            this.rampUpInfo = rampUp;
            return this;
        }

        public Builder withThrottling(ThrottlingInfo throttlingInfo) {
            this.throttlingInfo = throttlingInfo;
            return this;
        }

        public Builder withTestInstance(Object testInstance) {
            this.testInstance = testInstance;
            return this;
        }

        public Builder withSimulationClass(Class<?> simulationClass) {
            this.simulationClass = simulationClass;
            return this;
        }

        public Builder withRunner(Class<? extends SimulationRunner> runner) {
            this.runner = runner;
            return this;
        }

        public Builder withScenarios(List<Scenario> scenarios) {
            this.scenarios = scenarios;
            return this;
        }

        public Builder withSpecs(List<LoadDsl> specs) {
            this.specs = specs;
            return this;
        }

        public Builder withPrepare(Method prepareMethod) {
            this.prepareMethod = prepareMethod;
            return this;
        }

        public Builder withCleanUp(Method cleanUpMethod) {
            this.cleanUpMethod = cleanUpMethod;
            return this;
        }

        public Builder withBefore(Method beforeMethod) {
            this.beforeMethod = beforeMethod;
            return this;
        }

        public Builder withAfter(Method afterMethod) {
            this.afterMethod = afterMethod;
            return this;
        }

        public Builder withUserRepository(UserRepository<UserSession> userRepository) {
            this.userRepository = userRepository;
            return this;
        }

        public Builder withUserRegion(String userRegion) {
            this.userRegion = userRegion;
            return this;
        }

        public Builder withLogWriter(String reportingURI) {
            this.reportingURI = reportingURI;
            return this;
        }

        public Builder withLogFormatter(String logWriter) {
            this.reportingURI = logWriter;
            return this;
        }

        public Builder withDuration(Duration duration) {
            this.duration = duration;
            return this;
        }

        public SimulationMetadata build() {
            return new SimulationMetadata(this);
        }
    }
}

