/*
 * Decompiled with CFR 0.152.
 */
package io.ryos.rhino.sdk;

import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class CyclicIterator<T>
implements Iterator<T> {
    private final AtomicInteger cursor = new AtomicInteger(-1);
    private final List<T> list;
    private volatile boolean hasNext = true;

    public CyclicIterator(List<T> list) {
        if (list.isEmpty()) {
            throw new IllegalArgumentException("Backing list in CyclicIterator is empty.");
        }
        this.list = list;
    }

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.cursor.getAndUpdate(p -> ++p % this.list.size());
        return this.list.get(this.cursor.get());
    }

    public void stop() {
        this.hasNext = false;
    }
}

