/*
 * Decompiled with CFR 0.152.
 */
package io.ryos.rhino.sdk.users;

import io.ryos.rhino.sdk.data.UserSession;
import io.ryos.rhino.sdk.data.UserSessionImpl;
import io.ryos.rhino.sdk.users.User;
import io.ryos.rhino.sdk.users.UserProvider;
import io.ryos.rhino.sdk.users.UserRepository;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.stream.Collectors;

public class DefaultUserRepositoryImpl
implements UserRepository<UserSession> {
    private Queue<User> users;

    public DefaultUserRepositoryImpl(UserProvider userProvider) {
        Objects.requireNonNull(userProvider);
        this.users = new LinkedBlockingQueue<User>(userProvider.readUsers());
    }

    @Override
    public UserSession take() {
        User user = this.users.peek();
        this.users.add(user);
        return new UserSessionImpl(user);
    }

    @Override
    public boolean has(int numberOfUsers) {
        return this.users.size() >= numberOfUsers;
    }

    @Override
    public List<UserSession> getUserSessions() {
        return this.users.stream().map(UserSessionImpl::new).collect(Collectors.toList());
    }
}

