/*
 * Decompiled with CFR 0.152.
 */
package io.ryos.rhino.sdk.users;

import io.ryos.rhino.sdk.users.User;
import io.ryos.rhino.sdk.users.UserImpl;
import io.ryos.rhino.sdk.users.UserProvider;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ClasspathUserProviderImpl
implements UserProvider {
    private static final Logger LOG = LogManager.getLogger(ClasspathUserProviderImpl.class);
    private final String pathToFile;
    private final AtomicInteger counter = new AtomicInteger(0);

    public ClasspathUserProviderImpl(String pathToCSVFile) {
        this.pathToFile = pathToCSVFile;
    }

    @Override
    public List<User> readUsers() {
        List<User> list;
        BufferedReader isr = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream(this.pathToFile)));
        try {
            List<User> collect = isr.lines().map(line -> line.split(";")).filter(arr -> ((String[])arr).length == 3).map(arr -> new UserImpl(arr[0], arr[1], this.counter.incrementAndGet(), arr[2])).collect(Collectors.toList());
            if (collect.isEmpty()) {
                LOG.info("No valid user found in " + this.pathToFile + ". The CSV file should contain lines in the following format: username;password;scope");
            }
            list = collect;
        }
        catch (Throwable throwable) {
            try {
                try {
                    isr.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                LOG.error((Object)e);
                return Collections.emptyList();
            }
        }
        isr.close();
        return list;
    }
}

