/*
 * Decompiled with CFR 0.152.
 */
package io.ryos.rhino.sdk.io;

import akka.actor.AbstractActor;
import akka.actor.Props;
import akka.japi.Creator;
import akka.japi.pf.ReceiveBuilder;
import io.ryos.rhino.sdk.io.ResultWriter;
import io.ryos.rhino.sdk.reporting.LogEvent;
import io.ryos.rhino.sdk.reporting.LogFormatter;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LogWriter
extends AbstractActor
implements ResultWriter {
    private static final Logger LOG = LogManager.getLogger(LogWriter.class);
    private final LogFormatter logFormatter;
    private Writer writer;

    public static <T extends LogFormatter> Props props(String pathToLogFile, T logFormatter) {
        return Props.create(LogWriter.class, (Creator & Serializable)() -> new LogWriter(pathToLogFile, logFormatter));
    }

    public LogWriter(String logFile, LogFormatter formatter) {
        this.logFormatter = formatter;
        try {
            this.writer = new BufferedWriter(new FileWriter(new File(Objects.requireNonNull(logFile))));
        }
        catch (IOException e) {
            LOG.error((Object)e);
        }
    }

    public void report(LogEvent report) {
        this.report(this.logFormatter.format(report));
    }

    @Override
    public void report(String report) {
        try {
            this.writer.write(report);
            this.writer.flush();
        }
        catch (IOException e) {
            LOG.error((Object)e);
        }
    }

    @Override
    public void close() throws IOException {
    }

    public AbstractActor.Receive createReceive() {
        return ReceiveBuilder.create().match(String.class, this::report).match(LogEvent.class, this::report).build();
    }
}

