/*
 * Decompiled with CFR 0.152.
 */
package io.ryos.rhino.sdk;

import io.ryos.rhino.sdk.utils.Environment;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class SimulationConfig {
    private static final String PACKAGE_TO_SCAN = "packageToScan";
    private static SimulationConfig instance;
    private final Properties properties = new Properties();
    private final String environment;

    private SimulationConfig(String path, Environment environment) {
        this.environment = environment.toString();
        this.loadConfig(path);
    }

    static SimulationConfig newInstance(String path, Environment environment) {
        if (instance != null) {
            return instance;
        }
        instance = new SimulationConfig(path, environment);
        return instance;
    }

    String getProperty(String prop) {
        return this.properties.getProperty(prop);
    }

    private void loadConfig(String path) {
        InputStream resourceAsStream = this.getClass().getResourceAsStream(path.replace("classpath://", ""));
        try {
            this.properties.load(resourceAsStream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    String getDBSupportInfluxURL() {
        return this.properties.getProperty("db.influx.url");
    }

    String getDBSupportInfluxDBName() {
        return this.properties.getProperty("db.influx.dbName");
    }

    String getDBSupportInfluxUsername() {
        return this.properties.getProperty("db.influx.username");
    }

    String getDBSupportInfluxPassword() {
        return this.properties.getProperty("db.influx.password");
    }

    String getAuthUserSource() {
        return this.properties.getProperty(this.environment + ".auth.userSource");
    }

    String getAuthClientId() {
        return this.properties.getProperty(this.environment + ".auth.clientId");
    }

    String getAuthApiKey() {
        return this.properties.getProperty(this.environment + ".auth.apiKey");
    }

    String getAuthEndpoint() {
        return this.properties.getProperty(this.environment + ".auth.endpoint");
    }

    String getAuthClientSecret() {
        return this.properties.getProperty(this.environment + ".auth.clientSecret");
    }

    String getEndpoint() {
        return this.properties.getProperty(this.environment + ".endpoint");
    }

    String getAuthGrantType() {
        return this.properties.getProperty(this.environment + ".auth.grantType");
    }

    String getPackageToScan() {
        return instance.getProperty(PACKAGE_TO_SCAN);
    }

    public static String getServiceEndpoint() {
        return instance.getEndpoint();
    }

    public static String getPackage() {
        return instance.getPackageToScan();
    }

    public static String getClientId() {
        return instance.getAuthClientId();
    }

    public static String getClientSecret() {
        return instance.getAuthClientSecret();
    }

    public static String getGrantType() {
        return instance.getAuthGrantType();
    }

    public static String getApiKey() {
        return instance.getAuthApiKey();
    }

    public static String getAuthServer() {
        return instance.getAuthEndpoint();
    }

    public static String getUserSource() {
        return instance.getAuthUserSource();
    }

    public static String getInfluxURL() {
        return instance.getDBSupportInfluxURL();
    }

    public static String getInfluxDBName() {
        return instance.getDBSupportInfluxDBName();
    }

    public static String getInfluxUsername() {
        return instance.getDBSupportInfluxUsername();
    }

    public static String getInfluxPassword() {
        return instance.getDBSupportInfluxPassword();
    }
}

