/*
 * Decompiled with CFR 0.152.
 */
package io.ryos.rhino.sdk;

import io.ryos.rhino.sdk.Recorder;
import io.ryos.rhino.sdk.reporting.LogEvent;
import io.ryos.rhino.sdk.reporting.SimulationEvent;
import java.util.ArrayList;
import java.util.List;

public class RecorderImpl
implements Recorder {
    private final List<LogEvent> events = new ArrayList<LogEvent>();
    private final String scenarioName;
    private final int userId;

    public RecorderImpl(String scenarioName, int userId) {
        this.scenarioName = scenarioName;
        this.userId = userId;
    }

    @Override
    public void record(String stepName, int status) {
        long end = System.currentTimeMillis();
        LogEvent lastEvent = this.events.get(this.events.size() - 1);
        long start = lastEvent.end;
        SimulationEvent simLog = new SimulationEvent();
        simLog.elapsed = end - start;
        simLog.start = start;
        simLog.end = end;
        simLog.step = stepName;
        simLog.scenario = this.scenarioName;
        simLog.userId = this.userId;
        simLog.status = Integer.toString(status);
        this.events.add(simLog);
    }

    void record(LogEvent event) {
        this.events.add(event);
    }

    public List<LogEvent> getEvents() {
        return this.events;
    }
}

