/*
 * Decompiled with CFR 0.152.
 */
package io.ryos.rhino.sdk.utils;

import io.ryos.rhino.sdk.data.Pair;
import io.ryos.rhino.sdk.exceptions.Exceptions;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ReflectionUtils {
    private static final Logger LOG = LogManager.getLogger(ReflectionUtils.class);

    public static <T extends Annotation> Pair<Optional<Field>, T> findFieldByAnnotation(Class clazz, Class<T> clazzA) {
        Optional<Field> field = Arrays.stream(clazz.getDeclaredFields()).filter(m -> Arrays.stream(m.getDeclaredAnnotations()).anyMatch(clazzA::isInstance)).findFirst();
        return new Pair<Optional<Field>, Annotation>(field, field.map(f -> f.getDeclaredAnnotationsByType(clazzA)[0]).orElseThrow());
    }

    public static <T extends Annotation> Optional<Pair<Field, T>> getFieldByAnnotation(Class clazz, Class<T> clzAnnotation) {
        Optional<Field> field = Arrays.stream(clazz.getDeclaredFields()).filter(m -> Arrays.stream(m.getDeclaredAnnotations()).anyMatch(clzAnnotation::isInstance)).findFirst();
        return field.map(fld -> new Pair<Field, Annotation>((Field)fld, fld.getDeclaredAnnotationsByType(clzAnnotation)[0]));
    }

    public static <T extends Annotation> Optional<T> getClassLevelAnnotation(Class clazz, Class<T> annotation) {
        return Optional.ofNullable(clazz.getDeclaredAnnotation(annotation));
    }

    static Optional<Constructor> getDefaultConstructor(Class clazz) {
        try {
            return Optional.of(clazz.getConstructor(new Class[0]));
        }
        catch (NoSuchMethodException e) {
            Exceptions.rethrow(e, RuntimeException.class);
            LOG.error((Object)e);
            return Optional.empty();
        }
    }

    public static <T> Optional<T> instanceOf(Class<T> clazz) {
        Constructor defaultConstructor = ReflectionUtils.getDefaultConstructor(clazz).orElseThrow();
        try {
            return Optional.of(defaultConstructor.newInstance(new Object[0]));
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            LOG.error((Object)e);
            return Optional.empty();
        }
    }
}

