/*
 * Decompiled with CFR 0.152.
 */
package io.ryos.rhino.sdk.users;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.ryos.rhino.sdk.SimulationConfig;
import io.ryos.rhino.sdk.data.UserSession;
import io.ryos.rhino.sdk.data.UserSessionImpl;
import io.ryos.rhino.sdk.users.OAuthEntity;
import io.ryos.rhino.sdk.users.OAuthUserImpl;
import io.ryos.rhino.sdk.users.User;
import io.ryos.rhino.sdk.users.UserProvider;
import io.ryos.rhino.sdk.users.UserRepository;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.Response;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OAuthUserRepositoryImpl
implements UserRepository<UserSession> {
    private static final Logger LOG = LogManager.getLogger(OAuthUserRepositoryImpl.class);
    private static final String CLIENT_ID = "client_id";
    private static final String CLIENT_SECRET = "client_secret";
    private static final String GRANT_TYPE = "grant_type";
    private static final String USERNAME = "username";
    private static final String PASSWORD = "password";
    private static final String SCOPE = "scope";
    private final List<UserSession> authUsers;
    private final List<User> users;
    private final ExecutorService executorService;
    private final AtomicInteger cursor = new AtomicInteger(-1);
    private final long loginDelay;
    private final ObjectMapper objectMapper = new ObjectMapper();

    public OAuthUserRepositoryImpl(UserProvider userProvider, long loginDelay) {
        Objects.requireNonNull(userProvider);
        this.users = userProvider.readUsers();
        this.authUsers = new ArrayList<UserSession>(this.users.size());
        this.loginDelay = loginDelay;
        this.executorService = Executors.newFixedThreadPool(1);
    }

    public OAuthUserRepositoryImpl authenticateAll() {
        System.out.println(String.format("! Found %d users. Authenticating with delay: %d ms ...", this.users.size(), this.loginDelay));
        this.users.forEach(u -> this.executorService.submit(() -> {
            this.delay();
            this.authenticate((User)u).ifPresent(a -> this.authUsers.add(new UserSessionImpl((User)a)));
        }));
        return this;
    }

    private void delay() {
        try {
            Thread.sleep(this.loginDelay);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private Optional<User> authenticate(User user) {
        try {
            Form form = new Form();
            form.param(CLIENT_ID, SimulationConfig.getClientId());
            form.param(CLIENT_SECRET, SimulationConfig.getClientSecret());
            form.param(GRANT_TYPE, SimulationConfig.getGrantType());
            form.param(SCOPE, user.getScope());
            form.param(USERNAME, user.getUsername());
            form.param(PASSWORD, user.getPassword());
            Client client = ClientBuilder.newClient();
            Response response = client.target(SimulationConfig.getAuthServer()).request().post(Entity.form((Form)form));
            if (response.getStatus() != Response.Status.OK.getStatusCode()) {
                LOG.error("Cannot login user, status=" + response.getStatus() + ", message=" + (String)response.readEntity(String.class));
                return Optional.empty();
            }
            String s = (String)response.readEntity(String.class);
            OAuthEntity o = (OAuthEntity)this.objectMapper.readValue(s, OAuthEntity.class);
            return Optional.of(new OAuthUserImpl(user.getUsername(), user.getPassword(), o.getAccessToken(), o.getRefreshToken(), user.getScope(), SimulationConfig.getClientId(), user.getId()));
        }
        catch (Exception e) {
            LOG.error((Object)e);
            return Optional.empty();
        }
    }

    @Override
    public UserSession take() {
        this.cursor.getAndUpdate(p -> (p + 1) % this.authUsers.size());
        return this.authUsers.get(this.cursor.get());
    }

    @Override
    public List<UserSession> getUserSessions() {
        return this.authUsers;
    }

    @Override
    public boolean has(int numberOfUsers) {
        if (this.users.size() < numberOfUsers) {
            throw new RuntimeException("Insufficient number of users read from the source.");
        }
        return this.authUsers.size() >= numberOfUsers;
    }
}

