/*
 * Decompiled with CFR 0.152.
 */
package io.ryos.rhino.sdk.reporting;

import io.ryos.rhino.sdk.reporting.LogEvent;
import io.ryos.rhino.sdk.reporting.LogFormatter;
import io.ryos.rhino.sdk.reporting.SimulationEvent;
import io.ryos.rhino.sdk.reporting.UserEvent;

public class GatlingLogFormatter
implements LogFormatter {
    public static final String GATLING_VERSION = "3.0.0-RC4";
    public static final String GATLING_HEADLINE_TEMPLATE = "RUN\t%s\t%s\t%s\trhino\t%s\n";

    @Override
    public String format(LogEvent event) {
        if (event instanceof SimulationEvent) {
            return this.convert((SimulationEvent)event);
        }
        if (event instanceof UserEvent) {
            return this.convert((UserEvent)event);
        }
        return "N/A";
    }

    private String convert(SimulationEvent event) {
        return String.format("REQUEST\t%s\t\t%s\t%s\t%s\t%s\t \n", event.userId, event.step, event.start, event.end, event.status.equals("200") ? "OK" : "KO");
    }

    private String convert(UserEvent event) {
        return String.format("USER\t%s\t%d\t%s\t%d\t%d\n", event.scenario, event.id, event.eventType, event.start, event.end);
    }
}

