/*
 * Decompiled with CFR 0.152.
 */
package io.ryos.rhino.sdk.io;

import akka.actor.AbstractActor;
import akka.actor.Props;
import akka.japi.pf.ReceiveBuilder;
import io.ryos.rhino.sdk.SimulationConfig;
import io.ryos.rhino.sdk.io.ResultWriter;
import io.ryos.rhino.sdk.reporting.LogEvent;
import io.ryos.rhino.sdk.reporting.SimulationEvent;
import java.util.Optional;
import org.influxdb.InfluxDB;
import org.influxdb.InfluxDBFactory;
import org.influxdb.dto.BatchPoints;
import org.influxdb.dto.Point;

public class InfluxDBWriter
extends AbstractActor
implements ResultWriter<LogEvent> {
    private static final String RHINO_TEST_DB = "rhino_test_db_";
    private final InfluxDB influxDB;
    private final String dbName = Optional.ofNullable(SimulationConfig.getInfluxDBName()).orElse("rhino_test_db_" + System.currentTimeMillis());

    public static <T extends InfluxDBWriter> Props props() {
        return Props.create(InfluxDBWriter.class, InfluxDBWriter::new);
    }

    public InfluxDBWriter() {
        this.influxDB = InfluxDBFactory.connect((String)SimulationConfig.getInfluxURL());
        this.influxDB.setLogLevel(InfluxDB.LogLevel.NONE);
        System.out.println("Creating DB for name: " + this.dbName);
        this.influxDB.createDatabase(this.dbName);
    }

    public AbstractActor.Receive createReceive() {
        return ReceiveBuilder.create().match(String.class, this::report).match(LogEvent.class, this::report).build();
    }

    @Override
    public void report(LogEvent logEvent) {
        if (!(logEvent instanceof SimulationEvent)) {
            return;
        }
        SimulationEvent report = (SimulationEvent)logEvent;
        BatchPoints batchPoints = BatchPoints.database((String)this.dbName).tag("async", "true").consistency(InfluxDB.ConsistencyLevel.ALL).build();
        Point.Builder builder = Point.measurement((String)report.scenario);
        builder.addField("status", report.status);
        builder.addField("step", report.step);
        builder.addField("pt", report.elapsed);
        Point point = builder.build();
        batchPoints.point(point);
        this.influxDB.write(batchPoints);
    }

    @Override
    public void report(String report) {
        System.out.println("string");
    }

    @Override
    public void close() {
    }
}

