/*
 * Decompiled with CFR 0.152.
 */
package io.ryos.rhino.sdk.io;

import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicInteger;

public class CyclicIterator<T>
implements Iterator<T> {
    private final AtomicInteger cursor = new AtomicInteger(-1);
    private final List<T> list;
    private volatile boolean hasNext = true;

    public CyclicIterator(List<T> list) {
        this.list = list;
    }

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.cursor.getAndUpdate(p -> (p + 1) % this.list.size());
        return this.list.get(this.cursor.get());
    }

    public void stop() {
        this.hasNext = false;
    }
}

