/*
 * Decompiled with CFR 0.152.
 */
package io.ryos.rhino.sdk;

import io.ryos.rhino.sdk.Application;
import io.ryos.rhino.sdk.Simulation;
import io.ryos.rhino.sdk.SimulationConfig;
import io.ryos.rhino.sdk.SimulationJobsScanner;
import io.ryos.rhino.sdk.SimulationRunner;
import io.ryos.rhino.sdk.SimulationRunnerImpl;
import io.ryos.rhino.sdk.SimulationSpec;
import io.ryos.rhino.sdk.data.ContextImpl;
import io.ryos.rhino.sdk.utils.Environment;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SimulationSpecImpl
implements SimulationSpec {
    private static Logger LOG = LogManager.getLogger(Simulation.class);
    private static final String JOB = "job";
    private final List<SimulationRunner> simulationRunners;

    public SimulationSpecImpl(String path, String simulationName) {
        Application.showBranding();
        Environment environment = this.getEnvironment();
        SimulationConfig simulationConfig = SimulationConfig.newInstance(path, environment);
        List<Simulation> jobs = SimulationJobsScanner.create().scan(simulationName, simulationConfig.getPackageToScan());
        this.simulationRunners = jobs.stream().map(this::getContext).map(SimulationRunnerImpl::new).collect(Collectors.toList());
    }

    private Environment getEnvironment() {
        String profile = System.getProperty("profile", "DEV");
        try {
            return Environment.valueOf(profile);
        }
        catch (IllegalArgumentException e) {
            System.out.println("! Profile not found: " + profile);
            System.exit(-1);
            return null;
        }
    }

    private ContextImpl getContext(Simulation job) {
        ContextImpl context = new ContextImpl();
        context.add(JOB, job);
        return context;
    }

    @Override
    public void start() {
        if (this.simulationRunners.isEmpty()) {
            System.out.println("No Simulation entity was found in package: " + SimulationConfig.getPackage());
        }
        this.simulationRunners.forEach(SimulationRunner::start);
    }

    @Override
    public void stop() {
        System.out.println("Stopping simulation...");
        this.simulationRunners.forEach(SimulationRunner::stop);
    }
}

