/*
 * Decompiled with CFR 0.152.
 */
package io.ryos.rhino.sdk;

import io.ryos.rhino.sdk.Simulation;
import io.ryos.rhino.sdk.SimulationJobsScanner;
import io.ryos.rhino.sdk.annotations.After;
import io.ryos.rhino.sdk.annotations.Before;
import io.ryos.rhino.sdk.annotations.CleanUp;
import io.ryos.rhino.sdk.annotations.Influx;
import io.ryos.rhino.sdk.annotations.Logging;
import io.ryos.rhino.sdk.annotations.Prepare;
import io.ryos.rhino.sdk.annotations.Scenario;
import io.ryos.rhino.sdk.annotations.UserFeeder;
import io.ryos.rhino.sdk.data.Pair;
import io.ryos.rhino.sdk.data.UserSession;
import io.ryos.rhino.sdk.exceptions.SimulationNotFoundException;
import io.ryos.rhino.sdk.users.DefaultUserRepositoryFactoryImpl;
import io.ryos.rhino.sdk.users.UserRepository;
import io.ryos.rhino.sdk.users.UserRepositoryFactory;
import io.ryos.rhino.sdk.utils.ReflectionUtils;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.JarURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.jar.JarEntry;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SimulationJobsScannerImpl
implements SimulationJobsScanner {
    private static final Logger LOG = LogManager.getLogger(SimulationJobsScannerImpl.class);
    private static final String DOT = ".";

    @Override
    public List<Simulation> scan(String forSimulation, String ... inPackages) {
        Objects.requireNonNull(inPackages, "inPackages must not be null.");
        Objects.requireNonNull(forSimulation, "forSimulation must not be null.");
        return Arrays.stream(inPackages).map(p -> p.replace(DOT, File.separator)).flatMap(p -> this.scanBenchmarkClassesIn((String)p).stream().filter(a -> forSimulation.equals(this.getSimulationName((Class)a)))).map(this::createBenchmarkJob).collect(Collectors.toList());
    }

    private List<Class> scanBenchmarkClassesIn(String path) {
        try {
            URL resource = this.getClass().getClassLoader().getResource(path);
            if (resource == null) {
                return Collections.emptyList();
            }
            if (this.isJarFile(resource)) {
                return this.getBenchmarkClassesFromJar(resource, path);
            }
            URL resourceURL = Optional.ofNullable(this.getClass().getClassLoader().getResource(path)).orElseThrow();
            File[] files = new File(resourceURL.toURI()).listFiles();
            if (files != null) {
                return Arrays.stream(files).filter(File::isFile).map(File::getName).map(f -> this.buildClassNameFrom(path, (String)f)).map(this::getClassFor).filter(this::isBenchmarkClass).collect(Collectors.toList());
            }
        }
        catch (URISyntaxException e) {
            LOG.error("URL syntax not valid.", (Throwable)e);
        }
        return Collections.emptyList();
    }

    private List<Class> getBenchmarkClassesFromJar(URL resource, String inPath) {
        ArrayList<Class> result = new ArrayList<Class>();
        try {
            JarURLConnection urlConnection = (JarURLConnection)new URL(resource.toExternalForm()).openConnection();
            Enumeration<JarEntry> entries = urlConnection.getJarFile().entries();
            while (entries.hasMoreElements()) {
                String className;
                Class classFor;
                JarEntry jarEntry = entries.nextElement();
                String jarEntryName = jarEntry.getRealName();
                if (!jarEntryName.contains(inPath) || !jarEntryName.endsWith(".class") || !this.isBenchmarkClass(classFor = this.getClassFor(className = jarEntryName.substring(0, jarEntryName.lastIndexOf(DOT)).replace(File.separator, DOT)))) continue;
                result.add(classFor);
            }
        }
        catch (IOException e) {
            LOG.error("Cannot scan the JAR file.", (Throwable)e);
        }
        return result;
    }

    private boolean isJarFile(URL resource) {
        String resourceURL = resource.toExternalForm();
        return resourceURL != null && resourceURL.contains(".jar!");
    }

    private String buildClassNameFrom(String path, String className) {
        return path.replace(File.separator, DOT) + DOT + className.substring(0, className.indexOf(DOT));
    }

    private boolean isBenchmarkClass(Class clazz) {
        return Arrays.stream(clazz.getDeclaredAnnotations()).anyMatch(f -> f instanceof io.ryos.rhino.sdk.annotations.Simulation);
    }

    private String getSimulationName(Class clazz) {
        return Arrays.stream(clazz.getDeclaredAnnotations()).filter(f -> f instanceof io.ryos.rhino.sdk.annotations.Simulation).findFirst().map(s -> ((io.ryos.rhino.sdk.annotations.Simulation)s).name()).orElse(null);
    }

    private Class getClassFor(String name) {
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private Simulation createBenchmarkJob(Class clazz) {
        io.ryos.rhino.sdk.annotations.Simulation scenarioAnnotation = clazz.getDeclaredAnnotation(io.ryos.rhino.sdk.annotations.Simulation.class);
        boolean enableInflux = clazz.getDeclaredAnnotation(Influx.class) != null;
        List<io.ryos.rhino.sdk.data.Scenario> stepMethods = Arrays.stream(clazz.getDeclaredMethods()).filter(m -> Arrays.stream(m.getDeclaredAnnotations()).anyMatch(a -> a instanceof Scenario)).map(s -> new io.ryos.rhino.sdk.data.Scenario(s.getDeclaredAnnotation(Scenario.class).name(), (Method)s)).collect(Collectors.toList());
        if (stepMethods.isEmpty()) {
            throw new SimulationNotFoundException(clazz.getName());
        }
        Logging loggingAnnotation = clazz.getDeclaredAnnotation(Logging.class);
        String logger = Optional.ofNullable(loggingAnnotation).map(Logging::file).orElse(null);
        Optional<Pair<Field, UserFeeder>> injectAnnotationField = ReflectionUtils.getFieldByAnnotation(clazz, UserFeeder.class);
        Integer maxUserInject = injectAnnotationField.map(p -> ((UserFeeder)p.second).max()).orElse(10);
        UserRepository<UserSession> userRepo = injectAnnotationField.map(p -> this.createUserRepository((UserFeeder)p.second)).orElse(new DefaultUserRepositoryFactoryImpl().create());
        return new Simulation.Builder().withSimulationClass(clazz).withUserRepository(userRepo).withSimulation(scenarioAnnotation.name()).withDuration(scenarioAnnotation.durationInMins()).withInjectUser(maxUserInject).withLogWriter(this.validateLogFile(logger)).withInflux(enableInflux).withPrepare(this.findMethodWith(clazz, Prepare.class).orElse(null)).withCleanUp(this.findMethodWith(clazz, CleanUp.class).orElse(null)).withBefore(this.findMethodWith(clazz, Before.class).orElse(null)).withAfter(this.findMethodWith(clazz, After.class).orElse(null)).withScenarios(stepMethods).withRampUp(-1).build();
    }

    private String validateLogFile(String logFile) {
        File simFile = new File(logFile);
        try {
            boolean newFile = simFile.createNewFile();
            if (!newFile && !simFile.canWrite()) {
                throw new IOException("Not sufficient permissions to write the simulation file: " + simFile);
            }
        }
        catch (IOException e) {
            System.err.println(String.format("! Simulation log file is invalid: \"%s\"", simFile));
            System.exit(-1);
        }
        return logFile;
    }

    private UserRepository createUserRepository(UserFeeder feeder) {
        Class<? extends UserRepositoryFactory> factory = feeder.factory();
        long loginDelay = feeder.delay();
        try {
            Constructor<? extends UserRepositoryFactory> factoryConstructor = factory.getConstructor(Long.TYPE);
            UserRepositoryFactory userRepositoryFactory = factoryConstructor.newInstance(loginDelay);
            return userRepositoryFactory.create();
        }
        catch (NoSuchMethodException nsme) {
            return this.createWithDefaultConstructor(factory);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            LOG.error((Object)e);
            throw new RuntimeException("No user repository found.");
        }
    }

    private UserRepository createWithDefaultConstructor(Class<? extends UserRepositoryFactory> factory) {
        try {
            return factory.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]).create();
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            LOG.error((Object)e);
            throw new RuntimeException(e);
        }
    }

    private <T extends Annotation> Optional<Method> findMethodWith(Class<?> clazz, Class<T> annotation) {
        return Arrays.stream(clazz.getDeclaredMethods()).filter(m -> Arrays.stream(m.getDeclaredAnnotations()).anyMatch(annotation::isInstance)).findFirst();
    }
}

