/*
 * Decompiled with CFR 0.152.
 */
package io.ryos.rhino.sdk;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.Terminated;
import akka.dispatch.OnComplete;
import io.ryos.rhino.sdk.Recorder;
import io.ryos.rhino.sdk.RecorderImpl;
import io.ryos.rhino.sdk.annotations.Feeder;
import io.ryos.rhino.sdk.annotations.Logging;
import io.ryos.rhino.sdk.annotations.SessionFeeder;
import io.ryos.rhino.sdk.annotations.UserFeeder;
import io.ryos.rhino.sdk.data.InjectionPoint;
import io.ryos.rhino.sdk.data.Pair;
import io.ryos.rhino.sdk.data.Scenario;
import io.ryos.rhino.sdk.data.UserSession;
import io.ryos.rhino.sdk.feeders.Feed;
import io.ryos.rhino.sdk.io.InfluxDBWriter;
import io.ryos.rhino.sdk.io.LogWriter;
import io.ryos.rhino.sdk.reporting.GatlingLogFormatter;
import io.ryos.rhino.sdk.reporting.LogFormatter;
import io.ryos.rhino.sdk.reporting.UserEvent;
import io.ryos.rhino.sdk.users.User;
import io.ryos.rhino.sdk.users.UserRepository;
import io.ryos.rhino.sdk.utils.ReflectionUtils;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import scala.Function1;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;

public class Simulation {
    private static final String ACTOR_SYS_NAME = "benchmark";
    private static Logger LOG = LogManager.getLogger(Simulation.class);
    private String simulationName;
    private int duration;
    private int injectUser;
    private int rampUp;
    private Class simulationClass;
    private Supplier<Object> simulationInstanceFactory = () -> ReflectionUtils.instanceOf(this.simulationClass).orElseThrow();
    private List<Scenario> runnableScenarios;
    private Method beforeMethod;
    private Method afterMethod;
    private Method prepareMethod;
    private Method cleanupMethod;
    private UserRepository<UserSession> userRepository;
    private ActorRef loggerActor;
    private ActorRef influxActor;
    private boolean enableInflux;
    private ActorSystem system = ActorSystem.create((String)"benchmark");
    private final Predicate<Field> hasFeeder = f -> Arrays.stream(f.getDeclaredAnnotations()).anyMatch(Feeder.class::isInstance);
    private final Function<Field, InjectionPoint<Feeder>> ipCreator = f -> new InjectionPoint<Feeder>((Field)f, f.getDeclaredAnnotation(Feeder.class));

    private void feed(Object instance, InjectionPoint<Feeder> ip) {
        Feed o = ReflectionUtils.instanceOf(ip.getAnnotation().factory()).orElseThrow();
        Object value = o.take();
        try {
            Field field = ip.getField();
            field.setAccessible(true);
            field.set(instance, value);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            LOG.error("Feeder's return type and field's type is not compatible: " + e.getMessage());
        }
    }

    private void feedInjections(Object simulationInstance) {
        Arrays.stream(this.simulationClass.getDeclaredFields()).filter(this.hasFeeder).map(this.ipCreator).forEach(ip -> this.feed(simulationInstance, (InjectionPoint<Feeder>)ip));
    }

    private Simulation(Builder builder) {
        this.duration = builder.duration;
        this.simulationName = builder.simulation;
        this.injectUser = builder.injectUser;
        this.rampUp = builder.rampUp;
        this.simulationClass = builder.simulationClass;
        this.runnableScenarios = builder.runnerMethod;
        this.prepareMethod = builder.prepareMethod;
        this.cleanupMethod = builder.cleanUpMethod;
        this.beforeMethod = builder.beforeMethod;
        this.afterMethod = builder.afterMethod;
        this.userRepository = builder.userRepository;
        this.enableInflux = builder.enableInflux;
        String reportingURI = builder.reportingURI;
        LogFormatter formatter = this.getLogFormatter();
        if (this.enableInflux) {
            this.influxActor = this.system.actorOf(InfluxDBWriter.props(), InfluxDBWriter.class.getName());
        }
        this.loggerActor = this.system.actorOf(LogWriter.props(reportingURI, formatter), LogWriter.class.getName());
        if (formatter instanceof GatlingLogFormatter) {
            this.loggerActor.tell((Object)String.format("RUN\t%s\t%s\t%s\trhino\t%s\n", this.simulationClass.getName(), this.simulationName, System.currentTimeMillis(), "3.0.0-RC4"), ActorRef.noSender());
        }
    }

    private LogFormatter getLogFormatter() {
        Optional<Logging> loggingAnnotation = ReflectionUtils.getClassLevelAnnotation(this.simulationClass, Logging.class);
        Logging logging = loggingAnnotation.orElseThrow(() -> new RuntimeException("Please use @Logging annotation and provide log path for simulation logs. Please refer to rhino wiki how to use logging in Rhino projects."));
        Optional<? extends LogFormatter> logFormatterInstance = ReflectionUtils.instanceOf(logging.formatter());
        return logFormatterInstance.orElseThrow(RuntimeException::new);
    }

    public void prepare(UserSession userSession) {
        Object cleanUpInstance = this.prepareMethodCall(userSession);
        this.executeMethod(this.prepareMethod, cleanUpInstance);
    }

    private Object prepareMethodCall(UserSession userSession) {
        Object cleanUpInstance = this.simulationInstanceFactory.get();
        this.injectSession(userSession, cleanUpInstance);
        this.feedInjections(cleanUpInstance);
        this.injectUser(userSession.getUser(), cleanUpInstance);
        return cleanUpInstance;
    }

    public void cleanUp(UserSession userSession) {
        this.prepareMethodCall(userSession);
        this.executeMethod(this.cleanupMethod, userSession);
    }

    private void executeMethod(Method method, Object simulationInstance) {
        try {
            if (method != null) {
                method.invoke(simulationInstance, new Object[0]);
            }
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            LOG.error(e.getCause().getMessage());
            throw new RuntimeException("Cannot invoke the method with step: " + method.getName() + "()", e);
        }
    }

    private void executeScenario(Scenario scenario, RecorderImpl recorder, Object simulationInstance) {
        try {
            scenario.getMethod().invoke(simulationInstance, recorder);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            LOG.error(e.getCause().getMessage());
            throw new RuntimeException(e.getCause());
        }
    }

    private void injectSession(UserSession userSession, Object simulationInstance) {
        Optional<Pair<Field, SessionFeeder>> fieldAnnotation = ReflectionUtils.getFieldByAnnotation(this.simulationClass, SessionFeeder.class);
        fieldAnnotation.ifPresent(f -> this.setValueToInjectionPoint(userSession, (Field)f.first, simulationInstance));
    }

    private void injectUser(User user, Object simulationInstance) {
        Optional<Pair<Field, UserFeeder>> fieldAnnotation = ReflectionUtils.getFieldByAnnotation(this.simulationClass, UserFeeder.class);
        fieldAnnotation.ifPresent(f -> this.setValueToInjectionPoint(user, (Field)f.first, simulationInstance));
    }

    private <T> void setValueToInjectionPoint(T object, Field f, Object simulationInstance) {
        try {
            f.setAccessible(true);
            f.set(simulationInstance, object);
        }
        catch (IllegalAccessException e) {
            LOG.error((Object)e);
        }
    }

    public Recorder run(UserSession userSession, Scenario scenario) {
        User user = userSession.getUser();
        Object simulationInstance = this.simulationInstanceFactory.get();
        this.injectUser(user, simulationInstance);
        this.injectSession(userSession, simulationInstance);
        this.executeMethod(this.beforeMethod, simulationInstance);
        this.feedInjections(simulationInstance);
        RecorderImpl recorder = new RecorderImpl(scenario.getDescription(), user.getId());
        long start = System.currentTimeMillis();
        UserEvent userEventStart = new UserEvent();
        userEventStart.elapsed = 0L;
        userEventStart.start = start;
        userEventStart.end = start;
        userEventStart.scenario = scenario.getDescription();
        userEventStart.eventType = "START";
        userEventStart.id = user.getId();
        recorder.record(userEventStart);
        this.executeScenario(scenario, recorder, simulationInstance);
        long elapsed = System.currentTimeMillis() - start;
        UserEvent userEventEnd = new UserEvent();
        userEventEnd.elapsed = elapsed;
        userEventEnd.start = start;
        userEventEnd.end = start + elapsed;
        userEventEnd.scenario = scenario.getDescription();
        userEventEnd.eventType = "END";
        userEventEnd.id = user.getId();
        recorder.record(userEventEnd);
        recorder.getEvents().forEach(e -> this.loggerActor.tell(e, ActorRef.noSender()));
        if (this.enableInflux) {
            recorder.getEvents().forEach(e -> this.influxActor.tell(e, ActorRef.noSender()));
        }
        this.executeMethod(this.afterMethod, simulationInstance);
        return recorder;
    }

    public void stop() {
        Future terminate = this.system.terminate();
        terminate.onComplete((Function1)new OnComplete<Terminated>(){

            public void onComplete(Throwable throwable, Terminated terminated) throws Throwable {
                Simulation.this.system = null;
            }
        }, (ExecutionContext)this.system.dispatcher());
    }

    public String getSimulationName() {
        return this.simulationName;
    }

    public int getInjectUser() {
        return this.injectUser;
    }

    public int getRampUp() {
        return this.rampUp;
    }

    public UserRepository<UserSession> getUserRepository() {
        return this.userRepository;
    }

    public int getDuration() {
        return this.duration;
    }

    public List<Scenario> getRunnableScenarios() {
        return this.runnableScenarios;
    }

    static class Builder {
        private String simulation;
        private int injectUser;
        private int rampUp;
        private Class<?> simulationClass;
        private List<Scenario> runnerMethod;
        private Method prepareMethod;
        private Method cleanUpMethod;
        private Method beforeMethod;
        private Method afterMethod;
        private UserRepository<UserSession> userRepository;
        private String reportingURI;
        private String logFormatter;
        private int duration;
        private boolean enableInflux;

        Builder() {
        }

        public Builder withInflux(boolean enableInflux) {
            this.enableInflux = enableInflux;
            return this;
        }

        public Builder withSimulation(String simulation) {
            this.simulation = simulation;
            return this;
        }

        public Builder withInjectUser(int injectUser) {
            this.injectUser = injectUser;
            return this;
        }

        public Builder withRampUp(int rampUp) {
            this.rampUp = rampUp;
            return this;
        }

        public Builder withSimulationClass(Class<?> simulationClass) {
            this.simulationClass = simulationClass;
            return this;
        }

        public Builder withScenarios(List<Scenario> scenarios) {
            this.runnerMethod = scenarios;
            return this;
        }

        public Builder withPrepare(Method prepareMethod) {
            this.prepareMethod = prepareMethod;
            return this;
        }

        public Builder withCleanUp(Method cleanUpMethod) {
            this.cleanUpMethod = cleanUpMethod;
            return this;
        }

        public Builder withBefore(Method beforeMethod) {
            this.beforeMethod = beforeMethod;
            return this;
        }

        public Builder withAfter(Method afterMethod) {
            this.afterMethod = afterMethod;
            return this;
        }

        public Builder withUserRepository(UserRepository<UserSession> userRepository) {
            this.userRepository = userRepository;
            return this;
        }

        public Builder withLogWriter(String reportingURI) {
            this.reportingURI = reportingURI;
            return this;
        }

        public Builder withLogFormatter(String logWriter) {
            this.reportingURI = logWriter;
            return this;
        }

        public Builder withDuration(int duration) {
            this.duration = duration;
            return this;
        }

        public Simulation build() {
            return new Simulation(this);
        }
    }
}

