package io.rudin.webdoc.transformer.plantuml;

import io.rudin.webdoc.api.RawTransformer;
import io.rudin.webdoc.api.WebdocContext;

import java.io.ByteArrayOutputStream;
import java.io.IOException;

import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.SourceStringReader;

public class PlantumlTransformer implements RawTransformer
{

	@Override
	public String getSourceFileExtension() {
		return "plantuml.txt";
	}

	@Override
	public String getTargetFileExtension() {
		return "png";
	}

	@Override
	public byte[] transform(byte[] bytes, WebdocContext ctx) throws IOException
	{
		//http://plantuml.sourceforge.net/
		SourceStringReader reader = new SourceStringReader(new String(bytes));
		
		FileFormatOption option = new FileFormatOption(FileFormat.PNG);
		ByteArrayOutputStream output = new ByteArrayOutputStream();
		
		reader.generateDiagramDescription(output, option);
		
		return output.toByteArray();
	}

}
