package io.rudin.webdoc.transformer.markdown;

import io.rudin.webdoc.api.Transformer;
import io.rudin.webdoc.api.WebdocContext;

import org.pegdown.PegDownProcessor;

public class MarkdownTransformer implements Transformer
{
	private final PegDownProcessor proc = new PegDownProcessor();

	@Override
	public String getSourceFileExtension()
	{
		return "md";
	}

	@Override
	public String getTargetFileExtension()
	{
		return "html";
	}

	@Override
	public String transform(String str, WebdocContext ctx)
	{
		return proc.markdownToHtml(str);
	}

}
