/*
 * Decompiled with CFR 0.152.
 */
package io.rudin.webdoc.engine.handlebars;

import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.Helper;
import com.github.jknack.handlebars.Template;
import com.github.jknack.handlebars.io.AbstractTemplateLoader;
import com.github.jknack.handlebars.io.TemplateLoader;
import com.github.jknack.handlebars.io.TemplateSource;
import io.rudin.webdoc.api.TemplateEngine;
import io.rudin.webdoc.api.WebdocContext;
import io.rudin.webdoc.engine.handlebars.helpers.CodeHelper;
import io.rudin.webdoc.engine.handlebars.helpers.IncludeHelper;
import io.rudin.webdoc.util.StreamUtil;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HandlebarsEngine
implements TemplateEngine {
    private final Handlebars handlebars = new Handlebars((TemplateLoader)new ClasspathPartialLoader());
    private WebdocContext ctx;

    public HandlebarsEngine() {
        this.handlebars.registerHelper("include", (Helper)new IncludeHelper());
        this.handlebars.registerHelper("code", (Helper)new CodeHelper(this));
    }

    public String apply(String template, WebdocContext ctx) throws Exception {
        this.ctx = ctx;
        Template tmpl = this.handlebars.compileInline(template);
        return tmpl.apply((Object)ctx.getContext());
    }

    public WebdocContext getContext() {
        return this.ctx;
    }

    static class ClasspathTemplateSource
    implements TemplateSource {
        private final String content;
        private final String filename;
        private final long mtime;

        public ClasspathTemplateSource(String filename) throws IOException {
            this.filename = filename;
            this.mtime = System.currentTimeMillis();
            InputStream inputStream = HandlebarsEngine.class.getResourceAsStream("/" + filename);
            this.content = StreamUtil.streamToString((InputStream)inputStream);
        }

        public String content() throws IOException {
            return this.content;
        }

        public String filename() {
            return this.filename;
        }

        public long lastModified() {
            return this.mtime;
        }
    }

    static class ClasspathPartialLoader
    extends AbstractTemplateLoader {
        private static final Logger logger = LoggerFactory.getLogger(ClasspathPartialLoader.class);

        ClasspathPartialLoader() {
        }

        public TemplateSource sourceAt(String location) throws IOException {
            logger.debug("partial sourceAt: {}", (Object)location);
            return new ClasspathTemplateSource(location);
        }
    }
}

