package io.rudin.webdoc.engine.handlebars.helpers;

import io.rudin.webdoc.util.StreamUtil;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.StringReader;

import com.github.jknack.handlebars.Helper;
import com.github.jknack.handlebars.Options;

public class IncludeHelper implements Helper<String>
{

	@Override
	public CharSequence apply(String context, Options options) throws IOException
	{
		File file = new File(context);
		try (FileInputStream input = new FileInputStream(file))
		{
			String result = StreamUtil.streamToString(input);
			
			Object indentOption = options.hash.get("indent");
			
			if (indentOption != null)
			{
				int indent = Integer.parseInt(indentOption.toString());
				
				ByteArrayOutputStream outputStream = new ByteArrayOutputStream(result.length());
				PrintStream printStream = new PrintStream(outputStream);
				
				String line = null;
				BufferedReader reader = new BufferedReader(new StringReader(result));
				do
				{
					line = reader.readLine();
					
					if (line == null)
						break;
					
					for (int i=0; i<indent; i++)
						printStream.print(" ");
						
					printStream.println(line);
				}
				while (true);
				
				printStream.close();
				
				return outputStream.toString();
			}
			
			return result;
		}
	}

	
	
}
