package io.rudin.webdoc.engine.handlebars.helpers;

import io.rudin.webdoc.engine.handlebars.HandlebarsEngine;
import io.rudin.webdoc.util.StreamUtil;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.StringReader;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.github.jknack.handlebars.Helper;
import com.github.jknack.handlebars.Options;

public class CodeHelper implements Helper<String>
{
	private static final Logger logger = LoggerFactory.getLogger(CodeHelper.class);

	public CodeHelper(HandlebarsEngine engine)
	{
		this.engine = engine;
	}
	
	private final HandlebarsEngine engine;
	
	@Override
	public CharSequence apply(String context, Options options) throws IOException
	{
		File file = new File(engine.getContext().getCurrentDir(), context);
		File cwd = new File(".");
		
		InputStream input;
		
		if (file.exists())
			input = new FileInputStream(file);
		else
			input = CodeHelper.class.getResourceAsStream(context);
		
		if (input == null)
			throw new FileNotFoundException(file.toString() + " in cwd: " + cwd.getAbsolutePath());
		
		try
		{
			String result = StreamUtil.streamToString(input);

			Object start = options.hash.get("start");
			Object stop = options.hash.get("stop");

			ByteArrayOutputStream outputStream = new ByteArrayOutputStream(result.length());
			PrintStream printStream = new PrintStream(outputStream);

			boolean markfound = start == null;
			
			String line = null;
			BufferedReader reader = new BufferedReader(new StringReader(result));
			do
			{
				line = reader.readLine();

				if (line == null)
					break;

				if (stop != null && line.contains(stop.toString()))
					markfound = false;

				if (markfound)
					printStream.println("\t" + line);

				if (start != null && line.contains(start.toString()))
					markfound = true;
				
			}
			while (true);

			printStream.close();

			return outputStream.toString();

		}
		catch (Exception e)
		{
			logger.error("apply", e);
			throw e;
		}
		finally
		{
			input.close();
		}
	}



}
