/*
 * Decompiled with CFR 0.152.
 */
package io.rudin.webdoc.core.visitor;

import io.rudin.webdoc.api.WebdocContext;
import io.rudin.webdoc.core.callback.TransformerCallback;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;

public abstract class AbstractFileVisitor
extends SimpleFileVisitor<Path> {
    protected final Path targetPath;
    protected final TransformerCallback callback;
    protected final WebdocContext ctx;
    protected Path sourcePath = null;

    public AbstractFileVisitor(Path targetPath, TransformerCallback callback, WebdocContext ctx) {
        this.targetPath = targetPath;
        this.callback = callback;
        this.ctx = ctx;
    }

    @Override
    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
        if (this.sourcePath == null) {
            this.sourcePath = dir;
        } else {
            Files.createDirectories(this.targetPath.resolve(this.sourcePath.relativize(dir)), new FileAttribute[0]);
        }
        return FileVisitResult.CONTINUE;
    }

    protected abstract void visitFile(File var1, Path var2) throws Exception;

    @Override
    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
        String baseDir = "";
        Path relativePath = this.sourcePath.relativize(file);
        for (int i = 1; i < relativePath.getNameCount(); ++i) {
            baseDir = baseDir + "../";
        }
        Path newPath = this.targetPath.resolve(this.sourcePath.relativize(file));
        this.ctx.getContext().put("basedir", baseDir);
        File sourceFile = file.toFile();
        try {
            this.visitFile(sourceFile, newPath);
        }
        catch (Exception e) {
            throw new IOException("visitFile", e);
        }
        return FileVisitResult.CONTINUE;
    }
}

