/*
 * Decompiled with CFR 0.152.
 */
package io.rudin.webdoc.core.template;

import io.rudin.webdoc.api.RawTransformer;
import io.rudin.webdoc.api.TemplateEngine;
import io.rudin.webdoc.api.Transformer;
import io.rudin.webdoc.api.WebdocContext;
import io.rudin.webdoc.core.callback.TransformerCallback;
import io.rudin.webdoc.core.spi.RawTransformerLoader;
import io.rudin.webdoc.core.spi.TemplateEngineLoader;
import io.rudin.webdoc.core.spi.TransformerLoader;
import io.rudin.webdoc.core.template.TemplateTransformer;
import io.rudin.webdoc.util.StreamUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransformFileVisitor
extends SimpleFileVisitor<Path> {
    private static final Logger logger = LoggerFactory.getLogger(TransformFileVisitor.class);
    private final Path targetPath;
    private final TemplateTransformer templateTransformer;
    private final TransformerCallback callback;
    private final WebdocContext ctx;
    private Path sourcePath = null;

    public TransformFileVisitor(Path targetPath, TemplateTransformer templateTransformer, TransformerCallback callback, WebdocContext ctx) {
        this.targetPath = targetPath;
        this.callback = callback;
        this.templateTransformer = templateTransformer;
        this.ctx = ctx;
    }

    @Override
    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
        if (this.sourcePath == null) {
            this.sourcePath = dir;
        } else {
            Files.createDirectories(this.targetPath.resolve(this.sourcePath.relativize(dir)), new FileAttribute[0]);
        }
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
        Throwable throwable;
        FileInputStream fileInput;
        String baseDir = "";
        Path relativePath = this.sourcePath.relativize(file);
        for (int i = 1; i < relativePath.getNameCount(); ++i) {
            baseDir = baseDir + "../";
        }
        Path newPath = this.targetPath.resolve(this.sourcePath.relativize(file));
        this.ctx.getContext().put("basedir", baseDir);
        File sourceFile = file.toFile();
        byte[] outputData = null;
        this.ctx.setCurrentDir(sourceFile.getParentFile());
        for (RawTransformer rawTransformer : RawTransformerLoader.getTransformerlist()) {
            if (!file.toString().endsWith(rawTransformer.getSourceFileExtension())) continue;
            try {
                fileInput = new FileInputStream(sourceFile);
                throwable = null;
                try {
                    logger.debug("visit file : '{}'", (Object)file);
                    outputData = StreamUtil.streamToBytes((InputStream)fileInput);
                    logger.debug("\t- read {} bytes", (Object)outputData.length);
                    outputData = rawTransformer.transform(outputData, this.ctx);
                    logger.debug("\t- bytes after markup transformation: {}", (Object)outputData.length);
                    Path relativeFilePath = this.sourcePath.relativize(file);
                    Object newFileString = relativeFilePath.toString().substring(0, relativeFilePath.toString().length() - rawTransformer.getSourceFileExtension().length());
                    newFileString = (String)newFileString + rawTransformer.getTargetFileExtension();
                    newPath = this.targetPath.resolve((String)newFileString);
                    break;
                }
                catch (Throwable relativeFilePath) {
                    throwable = relativeFilePath;
                    throw relativeFilePath;
                }
                finally {
                    if (fileInput != null) {
                        if (throwable != null) {
                            try {
                                fileInput.close();
                            }
                            catch (Throwable relativeFilePath) {
                                throwable.addSuppressed(relativeFilePath);
                            }
                        } else {
                            fileInput.close();
                        }
                    }
                }
            }
            catch (Exception e) {
                throw new IOException("rawtransform", e);
            }
        }
        for (Transformer transformer : TransformerLoader.getTransformerlist()) {
            if (!file.toString().endsWith(transformer.getSourceFileExtension())) continue;
            try {
                fileInput = new FileInputStream(sourceFile);
                throwable = null;
                try {
                    logger.debug("visit file : '{}'", (Object)file);
                    String str = StreamUtil.streamToString((InputStream)fileInput);
                    logger.debug("\t- read {} bytes", (Object)str.length());
                    for (TemplateEngine engine : TemplateEngineLoader.getList()) {
                        str = engine.apply(str, this.ctx);
                    }
                    logger.debug("\t- bytes after templating engine: {}", (Object)str.length());
                    str = transformer.transform(str, this.ctx);
                    logger.debug("\t- bytes after markup transformation: {}", (Object)str.length());
                    if (this.templateTransformer != null) {
                        str = this.templateTransformer.applyTemplate(str);
                    }
                    logger.debug("\t- bytes after template application: {}", (Object)str.length());
                    Path relativeFilePath = this.sourcePath.relativize(file);
                    String newFileString = relativeFilePath.toString().substring(0, relativeFilePath.toString().length() - transformer.getSourceFileExtension().length());
                    newFileString = newFileString + transformer.getTargetFileExtension();
                    newPath = this.targetPath.resolve(newFileString);
                    outputData = str.getBytes();
                    break;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (fileInput != null) {
                        if (throwable != null) {
                            try {
                                fileInput.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            fileInput.close();
                        }
                    }
                }
            }
            catch (Exception e) {
                throw new IOException("transform", e);
            }
        }
        if (outputData != null) {
            this.callback.callback(file.toString(), newPath.toString());
            File newFile = newPath.toFile();
            newFile.getParentFile().mkdirs();
            FileOutputStream fileOutputStream = new FileOutputStream(newFile);
            fileOutputStream.write(outputData);
            fileOutputStream.close();
        }
        return FileVisitResult.CONTINUE;
    }
}

