/*
 * Decompiled with CFR 0.152.
 */
package io.rudin.webdoc.core.template;

import io.rudin.webdoc.core.callback.TransformerCallback;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;

public class TemplateDirCopyVisitor
extends SimpleFileVisitor<Path> {
    private final Path targetPath;
    private final TransformerCallback callback;
    private Path sourcePath = null;

    public TemplateDirCopyVisitor(Path targetPath, TransformerCallback callback) {
        this.targetPath = targetPath;
        this.callback = callback;
    }

    @Override
    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
        if (this.sourcePath == null) {
            this.sourcePath = dir;
        } else {
            Files.createDirectories(this.targetPath.resolve(this.sourcePath.relativize(dir)), new FileAttribute[0]);
        }
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
        Path relativePath = this.sourcePath.relativize(file);
        if (relativePath.toString().equals("template.html")) {
            return FileVisitResult.CONTINUE;
        }
        Path absoluteTargetPath = this.targetPath.resolve(relativePath);
        this.callback.callback(file.toString(), absoluteTargetPath.toString());
        Files.copy(file, absoluteTargetPath, StandardCopyOption.REPLACE_EXISTING);
        return FileVisitResult.CONTINUE;
    }
}

