/*
 * Decompiled with CFR 0.152.
 */
package io.rudin.webdoc.core;

import io.rudin.webdoc.api.WebdocContext;
import io.rudin.webdoc.core.callback.TransformerCallback;
import io.rudin.webdoc.core.template.TemplateDirCopyVisitor;
import io.rudin.webdoc.core.template.TemplateTransformer;
import io.rudin.webdoc.core.template.TransformFileVisitor;
import java.io.File;
import java.io.FileInputStream;
import java.nio.file.Files;
import java.util.HashMap;
import java.util.Map;

public class WebdocGenerator {
    private final File templateDir;
    private final File contentDir;
    private final Map<String, Object> context = new HashMap<String, Object>();

    public WebdocGenerator(File templateDir, File contentDir) {
        this.contentDir = contentDir;
        this.templateDir = templateDir;
    }

    public WebdocGenerator(File contentDir) {
        this.contentDir = contentDir;
        this.templateDir = null;
    }

    public void transform(File targetDir, TransformerCallback callback) throws Exception {
        TemplateTransformer templateTransformer = null;
        WebdocContext ctx = new WebdocContext();
        ctx.setContext(this.context);
        ctx.setContentDir(this.contentDir);
        ctx.setTargetDir(targetDir);
        ctx.setTemplateDir(this.templateDir);
        if (this.templateDir != null) {
            FileInputStream templateInputStream = new FileInputStream(this.templateDir + "/template.html");
            templateTransformer = new TemplateTransformer(templateInputStream, ctx);
            templateInputStream.close();
            Files.walkFileTree(this.templateDir.toPath(), new TemplateDirCopyVisitor(targetDir.toPath(), callback));
        }
        Files.walkFileTree(this.contentDir.toPath(), new TransformFileVisitor(targetDir.toPath(), templateTransformer, callback, ctx));
    }

    public Map<String, Object> getContext() {
        return this.context;
    }
}

