package io.rudin.webdoc.core.visitor;

import io.rudin.webdoc.api.WebdocContext;
import io.rudin.webdoc.core.callback.TransformerCallback;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;

/**
 * http://stackoverflow.com/questions/6214703/copy-entire-directory-contents-to-another-directory
 * @author user
 *
 */
public abstract class AbstractFileVisitor extends SimpleFileVisitor<Path>
{

	protected final Path targetPath;
	protected final TransformerCallback callback;
	protected final WebdocContext ctx;

	protected Path sourcePath = null;

	public AbstractFileVisitor(Path targetPath, TransformerCallback callback, WebdocContext ctx)
	{
		this.targetPath = targetPath;
		this.callback = callback;
		this.ctx = ctx;
	}


	@Override
	public FileVisitResult preVisitDirectory(final Path dir, final BasicFileAttributes attrs) throws IOException
	{
		if (sourcePath == null)
			sourcePath = dir;
		else
			Files.createDirectories(targetPath.resolve(sourcePath.relativize(dir)));

		return FileVisitResult.CONTINUE;
	}


	protected abstract void visitFile(File sourceFile, Path targetPath) throws Exception;

	@Override
	public FileVisitResult visitFile(final Path file, final BasicFileAttributes attrs) throws IOException
	{
		//Obtain basedir
		String baseDir = "";

		Path relativePath = sourcePath.relativize(file);
		for (int i=1; i<relativePath.getNameCount(); i++)
			baseDir += "../";

		Path newPath = targetPath.resolve(sourcePath.relativize(file));

		ctx.getContext().put("basedir", baseDir);

		//Mapping found
		File sourceFile = file.toFile();

		try
		{
			visitFile(sourceFile, newPath);
		}
		catch (Exception e)
		{
			throw new IOException("visitFile", e);
		}

		return FileVisitResult.CONTINUE;
	}
}