package io.rudin.webdoc.core.template;

import io.rudin.webdoc.api.TemplateEngine;
import io.rudin.webdoc.api.WebdocContext;
import io.rudin.webdoc.core.spi.TemplateEngineLoader;
import io.rudin.webdoc.util.StreamUtil;

import java.io.InputStream;


public class TemplateTransformer
{
	
	public TemplateTransformer(InputStream templateInput, WebdocContext ctx) throws Exception
	{
		this(StreamUtil.streamToString(templateInput), ctx);
	}
	
	public TemplateTransformer(String template, WebdocContext ctx) throws Exception
	{
		String str = template;
		
		this.template = str;
		this.ctx = ctx;
	}
		
	private final String template;
	private final WebdocContext ctx;

	
	/**
	 * Applies the template on the input string
	 * @param input
	 * @return
	 * @throws Exception 
	 */
	public String applyTemplate(String input) throws Exception
	{
		ctx.getContext().put("content", input);
		
		String output = template;
		
		//Apply template engines
		for (TemplateEngine engine: TemplateEngineLoader.getList())
			output = engine.apply(output, ctx);

		return output;
	}

	
}
