package io.rudin.webdoc.core;

import io.rudin.webdoc.api.WebdocContext;
import io.rudin.webdoc.core.callback.TransformerCallback;
import io.rudin.webdoc.core.template.TemplateDirCopyVisitor;
import io.rudin.webdoc.core.template.TemplateTransformer;
import io.rudin.webdoc.core.template.TransformFileVisitor;

import java.io.File;
import java.io.FileInputStream;
import java.nio.file.Files;
import java.util.HashMap;
import java.util.Map;

public class WebdocGenerator
{

	public WebdocGenerator(File templateDir, File contentDir)
	{
		this.contentDir = contentDir;
		this.templateDir = templateDir;
	}

	public WebdocGenerator(File contentDir)
	{
		this.contentDir = contentDir;
		this.templateDir = null;
	}

	private final File templateDir, contentDir;

	private final Map<String, Object> context = new HashMap<>();

	public void transform(File targetDir, TransformerCallback callback) throws Exception
	{
		TemplateTransformer templateTransformer = null;
		
		WebdocContext ctx = new WebdocContext();
		ctx.setContext(context);
		ctx.setContentDir(contentDir);
		ctx.setTargetDir(targetDir);
		ctx.setTemplateDir(templateDir);
		
		if (templateDir != null)
		{
			//Create template transformer
			FileInputStream templateInputStream = new FileInputStream(templateDir + "/template.html");
			templateTransformer = new TemplateTransformer(templateInputStream, ctx);
			templateInputStream.close();

			//Copy files from template dir
			Files.walkFileTree(templateDir.toPath(), new TemplateDirCopyVisitor(targetDir.toPath(), callback));
		}
		
		//transform content
		Files.walkFileTree(contentDir.toPath(), new TransformFileVisitor(targetDir.toPath(), templateTransformer, callback, ctx));

	}

	public Map<String, Object> getContext()
	{
		return context;
	}

}
