/*
 * Decompiled with CFR 0.152.
 */
package io.rudin.tomcat.embedded;

import io.rudin.tomcat.embedded.DeleteFileVisitor;
import io.rudin.tomcat.embedded.api.Plugin;
import io.rudin.tomcat.embedded.spi.PluginLoader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import li.rudin.core.util.args.ArgumentParser;
import li.rudin.core.util.stream.StreamUtil;
import net.lingala.zip4j.core.ZipFile;
import org.apache.catalina.startup.Tomcat;

public class TomcatStart {
    public static void main(String[] args) throws Exception {
        for (Plugin plugin : PluginLoader.getList()) {
            plugin.init(args);
        }
        ArgumentParser parser = new ArgumentParser(args);
        if (parser.isPresent("help")) {
            TomcatStart.usage();
            return;
        }
        int port = Integer.parseInt(parser.get("httpPort", "8080"));
        boolean resetExtract = parser.isPresent("resetExtract");
        File currentDir = new File(".");
        File baseDir = new File(currentDir, ".tomcat");
        if (resetExtract && baseDir.isDirectory()) {
            DeleteFileVisitor.delete(baseDir.toPath());
        }
        baseDir.mkdir();
        File appWar = new File(baseDir, "app.war");
        File appExploded = new File(baseDir, "appExploded");
        if (!appExploded.isDirectory()) {
            TomcatStart.extractWebapp(appWar, appExploded);
        }
        Tomcat tomcat = new Tomcat();
        for (Plugin plugin : PluginLoader.getList()) {
            plugin.preprocess(tomcat);
        }
        tomcat.setBaseDir(baseDir.getAbsolutePath());
        tomcat.setPort(port);
        tomcat.enableNaming();
        tomcat.addWebapp("/", appExploded.getAbsolutePath());
        for (Plugin plugin : PluginLoader.getList()) {
            plugin.postprocess(tomcat);
        }
        tomcat.start();
        tomcat.getServer().await();
        tomcat.stop();
    }

    private static void usage() {
        System.out.println("Tomcat embedded helper library (https://github.com/rudin-io/tomcat-embedded)");
        System.out.println("");
        System.out.println("Usage:");
        System.out.println("\t-httpPort <port>\t\t# use given port");
        System.out.println("\t-resetExtract\t\t\t# removes all previously generated files");
        System.out.println("\t-help\t\t\t\t\t# shows this message");
        System.out.println("");
        System.out.println("");
        for (Plugin plugin : PluginLoader.getList()) {
            plugin.printUsage(System.out);
        }
    }

    private static void extractWebapp(File appWar, File appExploded) throws Exception {
        InputStream inputStream = TomcatStart.class.getResourceAsStream("/app.war");
        if (inputStream == null) {
            throw new IllegalArgumentException("no embedded war @ /app.war found!");
        }
        FileOutputStream outputStream = new FileOutputStream(appWar);
        StreamUtil.copyStream((InputStream)inputStream, (OutputStream)outputStream);
        outputStream.close();
        appExploded.mkdir();
        ZipFile zipFile = new ZipFile(appWar);
        zipFile.extractAll(appExploded.getAbsolutePath());
    }
}

