package io.rudin.tomcat.embedded.api;

import java.io.PrintStream;

import org.apache.catalina.startup.Tomcat;

public interface Plugin
{
	/**
	 * Invoked on main startup
	 * @param args the command line arguments
	 */
	void init(String[] args);
	
	/**
	 * Preprocesses the tomcat instance
	 * @param tomcat
	 */
	void preprocess(Tomcat tomcat);
	
	/**
	 * Postprocessing on the tomcat instance
	 * @param tomcat
	 */
	void postprocess(Tomcat tomcat);
	
	/**
	 * Additional usage messages
	 * @param out
	 */
	void printUsage(PrintStream out);
}
