/*
 * Decompiled with CFR 0.152.
 */
package io.ruck.prefsfx;

import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;

public final class PreferenceContext {
    private static final Logger LOG = Logger.getLogger(PreferenceContext.class.getName());
    private static final Map<String, PreferenceContext> CONTEXTS = new ConcurrentHashMap<String, PreferenceContext>();
    private final Preferences preferences;

    private PreferenceContext(String name) {
        LOG.log(Level.FINE, "Creating {0} for {1}", new Object[]{this.getClass().getName().replaceAll("\n", "\\n"), name.replaceAll("\n", "\\n")});
        this.preferences = Preferences.userRoot().node(name);
    }

    public Preferences getPreferences() {
        return this.preferences;
    }

    public static PreferenceContext getContext(String name) {
        return CONTEXTS.computeIfAbsent(name.toLowerCase(Locale.getDefault()), PreferenceContext::new);
    }
}

