/*
 * Decompiled with CFR 0.152.
 */
package io.ruck.jgrok;

import io.ruck.jgrok.Patterns;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Grok {
    private static final Pattern GROK_SUBSTITUTION = Pattern.compile(".*?(?<WHOLE>%\\{(?<PATTERNNAME>[A-Z0-9_]+)(?::(?<KEYNAME>[a-z0-9_]+))?\\}).*", 0);
    private static final Logger log = LogManager.getLogger();
    private static String lastString = "`";
    private final String original;
    private final Pattern regex;
    private final Map<String, String> variables;

    private Grok(String original, String pattern, Map<String, String> variables, int regexflags) {
        this.original = original;
        this.regex = Pattern.compile(pattern, regexflags);
        this.variables = Collections.unmodifiableMap(variables);
    }

    public String getPattern() {
        return this.regex.pattern();
    }

    public String getOriginalPattern() {
        return this.original;
    }

    public Map<String, String> parse(String line) {
        HashMap<String, String> map = new HashMap<String, String>();
        Matcher m = this.regex.matcher(line);
        if (m.matches()) {
            this.variables.entrySet().stream().forEach(e -> map.put((String)e.getValue(), m.group((String)e.getKey())));
            return map;
        }
        return null;
    }

    public static Grok compile(String grokpattern, Patterns patterns) {
        HashMap<String, String> variables = new HashMap<String, String>();
        return Grok.compile(grokpattern, grokpattern, variables, patterns);
    }

    private static Grok compile(String original, String grokpattern, Map<String, String> variables, Patterns patterns) {
        log.log(Level.DEBUG, "compiling pattern {} => {}", new Object[]{original, grokpattern});
        Matcher m = GROK_SUBSTITUTION.matcher(Pattern.quote(grokpattern));
        if (m.matches()) {
            String whole = m.group("WHOLE");
            String patternname = m.group("PATTERNNAME");
            String varname = m.group("KEYNAME");
            String namedGroup = Grok.incrementString();
            if (varname != null) {
                variables.put(namedGroup, varname);
            }
            String prefix = varname != null ? "(?<" + namedGroup + ">" : "";
            String suffix = varname != null ? ")" : "";
            String pattern = patterns.get(patternname);
            if (pattern == null) {
                throw new IllegalArgumentException("Missing grok pattern " + patternname);
            }
            String replacement = prefix + pattern + suffix;
            String newpattern = grokpattern.replace(whole, replacement);
            return Grok.compile(original, newpattern, variables, patterns);
        }
        return new Grok(original, grokpattern, variables, 40);
    }

    private static String incrementString() {
        int i;
        char[] str = lastString.toCharArray();
        boolean allz = true;
        for (i = 0; i < str.length; ++i) {
            if (str[i] == 'z') continue;
            allz = false;
            break;
        }
        if (allz) {
            str = new char[str.length + 1];
            Arrays.fill(str, 'a');
        } else {
            for (i = str.length - 1; i >= 0; --i) {
                if (str[i] != 'z') {
                    int n = i;
                    str[n] = (char)(str[n] + '\u0001');
                    break;
                }
                str[i] = 97;
            }
        }
        lastString = new String(str);
        return lastString;
    }
}

