/*
 * Decompiled with CFR 0.152.
 */
package io.rtron.main.project;

import io.rtron.io.files.Path;
import io.rtron.io.logging.LogManager;
import io.rtron.io.logging.Logger;
import io.rtron.main.project.Project;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.time.Duration;
import kotlin.time.TimeMark;
import kotlin.time.TimeSource;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\u001aC\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00072\u0017\u0010\b\u001a\u0013\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00010\t\u00a2\u0006\u0002\b\u000b\u001aI\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\r2\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00072\u0017\u0010\u000e\u001a\u0013\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00010\t\u00a2\u0006\u0002\b\u000b\u00a8\u0006\u000f"}, d2={"processAllFiles", "", "inInputDirectory", "", "withExtension", "toOutputDirectory", "recursive", "", "setup", "Lkotlin/Function1;", "Lio/rtron/main/project/Project;", "Lkotlin/ExtensionFunctionType;", "withExtensions", "", "process", "rtron-main"})
public final class ProjectDSLKt {
    public static final void processAllFiles(@NotNull String inInputDirectory, @NotNull String withExtension, @NotNull String toOutputDirectory, boolean recursive, @NotNull Function1<? super Project, Unit> setup) {
        Intrinsics.checkNotNullParameter((Object)inInputDirectory, (String)"inInputDirectory");
        Intrinsics.checkNotNullParameter((Object)withExtension, (String)"withExtension");
        Intrinsics.checkNotNullParameter((Object)toOutputDirectory, (String)"toOutputDirectory");
        Intrinsics.checkNotNullParameter(setup, (String)"setup");
        ProjectDSLKt.processAllFiles(inInputDirectory, SetsKt.setOf((Object)withExtension), toOutputDirectory, recursive, setup);
    }

    public static /* synthetic */ void processAllFiles$default(String string, String string2, String string3, boolean bl, Function1 function1, int n, Object object) {
        if ((n & 4) != 0) {
            string3 = Intrinsics.stringPlus((String)string, (Object)"_output");
        }
        if ((n & 8) != 0) {
            bl = true;
        }
        ProjectDSLKt.processAllFiles(string, string2, string3, bl, (Function1<? super Project, Unit>)function1);
    }

    /*
     * WARNING - void declaration
     */
    public static final void processAllFiles(@NotNull String inInputDirectory, @NotNull Set<String> withExtensions, @NotNull String toOutputDirectory, boolean recursive, @NotNull Function1<? super Project, Unit> process) {
        Intrinsics.checkNotNullParameter((Object)inInputDirectory, (String)"inInputDirectory");
        Intrinsics.checkNotNullParameter(withExtensions, (String)"withExtensions");
        Intrinsics.checkNotNullParameter((Object)toOutputDirectory, (String)"toOutputDirectory");
        Intrinsics.checkNotNullParameter(process, (String)"process");
        Logger generalLogger = LogManager.INSTANCE.getReportLogger("general");
        Path inputDirectoryPath = new Path(inInputDirectory);
        Path outputDirectoryPath = new Path(toOutputDirectory);
        if (!inputDirectoryPath.isDirectory()) {
            generalLogger.error(Intrinsics.stringPlus((String)"Provided directory does not exist: ", (Object)inputDirectoryPath));
            return;
        }
        if (withExtensions.isEmpty()) {
            generalLogger.error("No extensions have been provided.");
            return;
        }
        if (outputDirectoryPath.isRegularFile()) {
            generalLogger.error(Intrinsics.stringPlus((String)"Output directory must not be a file: ", (Object)outputDirectoryPath));
            return;
        }
        int recursiveDepth = recursive ? Integer.MAX_VALUE : 1;
        List inputFilePaths2 = CollectionsKt.sorted((Iterable)SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)inputDirectoryPath.walk(recursiveDepth), (Function1)((Function1)new Function1<Path, Boolean>(withExtensions){
            final /* synthetic */ Set<String> $withExtensions;
            {
                this.$withExtensions = $withExtensions;
                super(1);
            }

            public final boolean invoke(@NotNull Path it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return this.$withExtensions.contains(it.getExtension());
            }
        }))));
        if (inputFilePaths2.isEmpty()) {
            generalLogger.error("No files have been found with " + withExtensions + " as extension in input directory: " + outputDirectoryPath);
            return;
        }
        int totalNumber = inputFilePaths2.size();
        Iterable $this$forEachIndexed$iv = inputFilePaths2;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            Project project;
            void currentPath;
            int n = index$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Path path = (Path)item$iv;
            int index = n;
            boolean bl2 = false;
            Path inputFileRelativePath = inputDirectoryPath.relativize((Path)currentPath);
            String projectId = inputFileRelativePath.toString();
            Path projectOutputDirectoryPath = outputDirectoryPath.resolve(inputFileRelativePath);
            Logger reportLogger = LogManager.INSTANCE.getReportLogger(projectId);
            Logger.info$default((Logger)reportLogger, (String)("Starting project (" + (index + 1) + '/' + totalNumber + ") \ud83d\udcaa\ud83d\udcaa\ud83d\udcaa"), null, null, (int)6, null);
            boolean $i$f$measureTime = false;
            boolean bl3 = false;
            TimeSource $this$measureTime$iv$iv = (TimeSource)TimeSource.Monotonic.INSTANCE;
            boolean $i$f$measureTime2 = false;
            boolean bl4 = false;
            TimeMark mark$iv$iv = $this$measureTime$iv$iv.markNow();
            boolean bl5 = false;
            Project project2 = project = new Project(projectId, (Path)currentPath, projectOutputDirectoryPath);
            boolean bl6 = false;
            boolean bl7 = false;
            process.invoke((Object)project2);
            long timeElapsed = mark$iv$iv.elapsedNow-UwyO8pc();
            Logger.info$default((Logger)reportLogger, (String)("Completed project after " + Duration.toString-impl((long)timeElapsed) + ". \u2714\u2714\u2714" + System.lineSeparator()), null, null, (int)6, null);
        }
    }

    public static /* synthetic */ void processAllFiles$default(String string, Set set, String string2, boolean bl, Function1 function1, int n, Object object) {
        if ((n & 4) != 0) {
            string2 = Intrinsics.stringPlus((String)string, (Object)"_output");
        }
        if ((n & 8) != 0) {
            bl = true;
        }
        ProjectDSLKt.processAllFiles(string, set, string2, bl, (Function1<? super Project, Unit>)function1);
    }
}

